/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppException;
import org.apache.camel.component.smpp.SmppSmCommand;
import org.apache.camel.component.smpp.SmppUtils;
import org.apache.camel.support.ExchangeHelper;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.ReplaceSm;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.session.SMPPSession;

public class SmppReplaceSmCommand
extends SmppSmCommand {
    public SmppReplaceSmCommand(SMPPSession session, SmppConfiguration config) {
        super(session, config);
    }

    @Override
    public void execute(Exchange exchange) throws SmppException {
        byte[] message = this.getShortMessage(exchange.getIn());
        ReplaceSm replaceSm = this.createReplaceSmTempate(exchange);
        replaceSm.setShortMessage(message);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending replacement command for a short message for exchange id '{}' and message id '{}'", (Object)exchange.getExchangeId(), (Object)replaceSm.getMessageId());
        }
        try {
            this.session.replaceShortMessage(replaceSm.getMessageId(), TypeOfNumber.valueOf(replaceSm.getSourceAddrTon()), NumberingPlanIndicator.valueOf(replaceSm.getSourceAddrNpi()), replaceSm.getSourceAddr(), replaceSm.getScheduleDeliveryTime(), replaceSm.getValidityPeriod(), new RegisteredDelivery(replaceSm.getRegisteredDelivery()), replaceSm.getSmDefaultMsgId(), replaceSm.getShortMessage());
        }
        catch (Exception e) {
            throw new SmppException(e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sent replacement command for a short message for exchange id '{}' and message id '{}'", (Object)exchange.getExchangeId(), (Object)replaceSm.getMessageId());
        }
        Message rspMsg = ExchangeHelper.getResultMessage(exchange);
        rspMsg.setHeader("CamelSmppId", replaceSm.getMessageId());
    }

    protected ReplaceSm createReplaceSmTempate(Exchange exchange) {
        Message in = exchange.getIn();
        ReplaceSm replaceSm = new ReplaceSm();
        if (in.getHeaders().containsKey("CamelSmppId")) {
            replaceSm.setMessageId(in.getHeader("CamelSmppId", String.class));
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddr")) {
            replaceSm.setSourceAddr(in.getHeader("CamelSmppSourceAddr", String.class));
        } else {
            replaceSm.setSourceAddr(this.config.getSourceAddr());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddrTon")) {
            replaceSm.setSourceAddrTon(in.getHeader("CamelSmppSourceAddrTon", Byte.class));
        } else {
            replaceSm.setSourceAddrTon(this.config.getSourceAddrTon());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddrNpi")) {
            replaceSm.setSourceAddrNpi(in.getHeader("CamelSmppSourceAddrNpi", Byte.class));
        } else {
            replaceSm.setSourceAddrNpi(this.config.getSourceAddrNpi());
        }
        if (in.getHeaders().containsKey("CamelSmppRegisteredDelivery")) {
            replaceSm.setRegisteredDelivery(in.getHeader("CamelSmppRegisteredDelivery", Byte.class));
        } else {
            replaceSm.setRegisteredDelivery(this.config.getRegisteredDelivery());
        }
        if (in.getHeaders().containsKey("CamelSmppScheduleDeliveryTime")) {
            replaceSm.setScheduleDeliveryTime(SmppUtils.formatTime(in.getHeader("CamelSmppScheduleDeliveryTime", Date.class)));
        }
        if (in.getHeaders().containsKey("CamelSmppValidityPeriod")) {
            Object validityPeriod = in.getHeader("CamelSmppValidityPeriod");
            if (validityPeriod instanceof String) {
                replaceSm.setValidityPeriod((String)validityPeriod);
            } else if (validityPeriod instanceof Date) {
                replaceSm.setValidityPeriod(SmppUtils.formatTime((Date)validityPeriod));
            }
        }
        return replaceSm;
    }
}

