/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import java.util.Arrays;
import java.util.Objects;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.OptionalParameters;

public class AbstractSmCommand
extends Command {
    private static final long serialVersionUID = 745091499168413812L;
    protected String serviceType;
    protected byte sourceAddrTon;
    protected byte sourceAddrNpi;
    protected String sourceAddr;
    protected byte destAddrTon;
    protected byte destAddrNpi;
    protected String destAddress;
    protected byte esmClass;
    protected byte registeredDelivery;
    protected byte dataCoding;
    protected OptionalParameter[] optionalParameters;

    public boolean isDefaultMessageType() {
        return AbstractSmCommand.isDefaultMessageType(this.esmClass);
    }

    public void setDefaultMessageType() {
        this.esmClass = AbstractSmCommand.composeDefaultMessageType(this.esmClass);
    }

    public boolean isUdhi() {
        return AbstractSmCommand.isUdhi(this.esmClass);
    }

    public void setUdhi() {
        this.esmClass = AbstractSmCommand.composeUdhi(this.esmClass);
    }

    public boolean isReplyPath() {
        return AbstractSmCommand.isReplyPath(this.esmClass);
    }

    public void setReplyPath() {
        this.esmClass = AbstractSmCommand.composeReplyPath(this.esmClass);
    }

    public boolean isUdhiAndReplyPath() {
        return AbstractSmCommand.isUdhiAndReplyPath(this.esmClass);
    }

    public void setUdhiAndReplyPath() {
        this.esmClass = AbstractSmCommand.composeUdhiAndReplyPath(this.esmClass);
    }

    public byte getDataCoding() {
        return this.dataCoding;
    }

    public void setDataCoding(byte dataCoding) {
        this.dataCoding = dataCoding;
    }

    public byte getDestAddrTon() {
        return this.destAddrTon;
    }

    public void setDestAddrTon(byte destAddrTon) {
        this.destAddrTon = destAddrTon;
    }

    public byte getDestAddrNpi() {
        return this.destAddrNpi;
    }

    public void setDestAddrNpi(byte destAddrNpi) {
        this.destAddrNpi = destAddrNpi;
    }

    public String getDestAddress() {
        return this.destAddress;
    }

    public void setDestAddress(String destAddress) {
        this.destAddress = destAddress;
    }

    public byte getEsmClass() {
        return this.esmClass;
    }

    public void setEsmClass(byte esmClass) {
        this.esmClass = esmClass;
    }

    public byte getRegisteredDelivery() {
        return this.registeredDelivery;
    }

    public void setRegisteredDelivery(byte registeredDelivery) {
        this.registeredDelivery = registeredDelivery;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public <U extends OptionalParameter> U getOptionalParameter(Class<U> tagClass) {
        return OptionalParameters.get(tagClass, this.optionalParameters);
    }

    public OptionalParameter getOptionalParameter(OptionalParameter.Tag tagEnum) {
        return OptionalParameters.get(tagEnum.code(), this.optionalParameters);
    }

    public OptionalParameter getOptionalParameter(short code) {
        return OptionalParameters.get(code, this.optionalParameters);
    }

    public OptionalParameter[] getOptionalParameters() {
        return this.optionalParameters;
    }

    public void setOptionalParameters(OptionalParameter ... optionalParametes) {
        this.optionalParameters = optionalParametes;
    }

    public byte getSourceAddrTon() {
        return this.sourceAddrTon;
    }

    public void setSourceAddrTon(byte sourceAddrTon) {
        this.sourceAddrTon = sourceAddrTon;
    }

    public byte getSourceAddrNpi() {
        return this.sourceAddrNpi;
    }

    public void setSourceAddrNpi(byte sourceAddrNpi) {
        this.sourceAddrNpi = sourceAddrNpi;
    }

    public String getSourceAddr() {
        return this.sourceAddr;
    }

    public void setSourceAddr(String sourceAddr) {
        this.sourceAddr = sourceAddr;
    }

    public static boolean isDefaultMessageType(byte esmClass) {
        return AbstractSmCommand.isMessageType(esmClass, (byte)0);
    }

    public static byte composeDefaultMessageType(byte esmClass) {
        return AbstractSmCommand.cleanMessageType(esmClass);
    }

    public static boolean isUdhi(byte esmClass) {
        return AbstractSmCommand.isSpecificFeatures(esmClass, (byte)64);
    }

    public static byte composeUdhi(byte esmClass) {
        return AbstractSmCommand.composeSpecificFeatures(esmClass, (byte)64);
    }

    public static boolean isReplyPath(byte esmClass) {
        return AbstractSmCommand.isSpecificFeatures(esmClass, (byte)-128);
    }

    public static byte composeReplyPath(byte esmClass) {
        return AbstractSmCommand.composeSpecificFeatures(esmClass, (byte)-128);
    }

    public static boolean isUdhiAndReplyPath(byte esmClass) {
        return AbstractSmCommand.isSpecificFeatures(esmClass, (byte)-64);
    }

    public static byte composeUdhiAndReplyPath(byte esmClass) {
        return AbstractSmCommand.composeSpecificFeatures(esmClass, (byte)-64);
    }

    protected static final boolean isMessagingMode(byte esmClass, byte messagingModeValue) {
        return (esmClass & 3) == messagingModeValue;
    }

    protected static final byte composeMessagingMode(byte esmClass, byte messagingModeValue) {
        return (byte)(AbstractSmCommand.cleanMessagingMode(esmClass) | messagingModeValue);
    }

    protected static final byte cleanMessagingMode(byte esmClass) {
        return (byte)(esmClass & 3);
    }

    protected static final boolean isMessageType(byte esmClass, byte messageTypeValue) {
        return (esmClass & 0x3C) == messageTypeValue;
    }

    protected static final byte composeMessageType(byte esmClass, byte messageTypeValue) {
        return (byte)(AbstractSmCommand.cleanMessageType(esmClass) | messageTypeValue);
    }

    protected static final byte cleanMessageType(byte esmClass) {
        return (byte)(esmClass & 0xC3);
    }

    protected static final boolean isSpecificFeatures(byte esmClass, byte specificFeaturesValue) {
        return (esmClass & 0xC0) == specificFeaturesValue;
    }

    protected static final byte composeSpecificFeatures(byte esmClass, byte specificFeaturesValue) {
        return (byte)(AbstractSmCommand.cleanSpecificFeatures(esmClass) | specificFeaturesValue);
    }

    protected static final byte cleanSpecificFeatures(byte esmClass) {
        return (byte)(esmClass & 0x3F);
    }

    protected static final boolean isSmscDeliveryReceipt(byte registeredDelivery, byte smscDeliveryReceiptValue) {
        return (registeredDelivery & 3) == smscDeliveryReceiptValue;
    }

    protected static final byte composeSmscDelReceipt(byte registeredDelivery, byte smscDeliveryReceiptValue) {
        return (byte)(AbstractSmCommand.cleanSmscDeliveryReceipt(registeredDelivery) | smscDeliveryReceiptValue);
    }

    protected static final byte cleanSmscDeliveryReceipt(byte registeredDelivery) {
        return (byte)(registeredDelivery & 0xFC);
    }

    protected static final boolean isSmeAck(byte registeredDelivery, byte smeOriginatedAckValue) {
        return (registeredDelivery & 0xC) == smeOriginatedAckValue;
    }

    protected static final byte composeSmeAck(byte registeredDelivery, byte smeOriginatedValue) {
        return (byte)(AbstractSmCommand.cleanSmeAck(registeredDelivery) | smeOriginatedValue);
    }

    protected static final byte cleanSmeAck(byte registeredDelivery) {
        return (byte)(registeredDelivery & 0xC);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AbstractSmCommand that = (AbstractSmCommand)o;
        return this.sourceAddrTon == that.sourceAddrTon && this.sourceAddrNpi == that.sourceAddrNpi && this.destAddrTon == that.destAddrTon && this.destAddrNpi == that.destAddrNpi && this.esmClass == that.esmClass && this.registeredDelivery == that.registeredDelivery && this.dataCoding == that.dataCoding && Objects.equals(this.serviceType, that.serviceType) && Objects.equals(this.sourceAddr, that.sourceAddr) && Objects.equals(this.destAddress, that.destAddress) && Arrays.equals(this.optionalParameters, that.optionalParameters);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.serviceType, this.sourceAddrTon, this.sourceAddrNpi, this.sourceAddr, this.destAddrTon, this.destAddrNpi, this.destAddress, this.esmClass, this.registeredDelivery, this.dataCoding);
        result = 31 * result + Arrays.hashCode(this.optionalParameters);
        return result;
    }
}

