/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean;

import org.jsmpp.bean.DataCodings;

public enum Alphabet {
    ALPHA_DEFAULT(0, true, false),
    ALPHA_IA5(1, true, false),
    ALPHA_UNSPECIFIED_2(2, true, true),
    ALPHA_LATIN1(3, true, false),
    ALPHA_8_BIT(4, true, true),
    ALPHA_JIS(5, true, false),
    ALPHA_CYRILLIC(6, true, false),
    ALPHA_LATIN_HEBREW(7, true, false),
    ALPHA_UCS2(8, true, false),
    ALPHA_PICTOGRAM_ENCODING(9, true, false),
    ALPHA_ISO_2022_JP_MUSIC_CODES(10, true, false),
    ALPHA_RESERVED_11(11, false, false),
    ALPHA_RESERVED_12(12, false, false),
    ALPHA_JIS_X_0212_1990(13, true, false),
    ALPHA_KS_C_5601(14, true, false),
    ALPHA_RESERVED_15(15, false, false);

    public static final byte MASK_ALPHABET = 15;
    public static final byte MASK_ALPHABET_MESSAGE_CLASS = 12;
    private final byte value;
    private final boolean valid;
    private final boolean unspecified;

    private Alphabet(byte value, boolean valid, boolean unspecified) {
        this.value = value;
        this.valid = valid;
        this.unspecified = unspecified;
    }

    public byte value() {
        return this.value;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isReserved() {
        return !this.isValid();
    }

    public boolean isUnspecified() {
        return this.unspecified;
    }

    public static Alphabet valueOf(byte value) throws IllegalArgumentException {
        for (Alphabet val : Alphabet.values()) {
            if (val.value != value) continue;
            return val;
        }
        throw new IllegalArgumentException("No enum const Alphabet with value " + value);
    }

    public static Alphabet parseDataCoding(byte dataCoding) throws IllegalArgumentException {
        int mask = DataCodings.containsMessageClass(dataCoding) ? 12 : 15;
        byte value = (byte)(dataCoding & mask);
        for (Alphabet val : Alphabet.values()) {
            if (val.value != value) continue;
            return val;
        }
        throw new IllegalArgumentException("No enum const Alphabet with value " + value + " for dataCoding " + dataCoding);
    }
}

