/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean.pid;

import java.util.Objects;
import org.jsmpp.bean.pid.ProtocolIdentifier;
import org.jsmpp.bean.pid.TelematicDevice;
import org.jsmpp.bean.pid.TelematicInterworkingIndicator;

public class ProtocolIdentifier00
implements ProtocolIdentifier {
    private TelematicInterworkingIndicator telematicInterworkingIndicator;
    private TelematicDevice telematicDevice;

    public ProtocolIdentifier00() {
        this.telematicInterworkingIndicator = TelematicInterworkingIndicator.NO_INTERWORKING;
    }

    public ProtocolIdentifier00(TelematicDevice telematicDevice) {
        this.telematicInterworkingIndicator = TelematicInterworkingIndicator.INTERWORKING;
        this.telematicDevice = telematicDevice;
    }

    public static ProtocolIdentifier00 valueOf(byte encoding) {
        if (encoding < 0 || encoding >= 64) {
            throw new IllegalArgumentException("encoding invalid");
        }
        ProtocolIdentifier00 protocolIdentifier = null;
        switch (TelematicInterworkingIndicator.valueOf(encoding)) {
            case NO_INTERWORKING: {
                protocolIdentifier = new ProtocolIdentifier00();
                break;
            }
            case INTERWORKING: {
                protocolIdentifier = new ProtocolIdentifier00(TelematicDevice.valueOf(encoding));
            }
        }
        return protocolIdentifier;
    }

    @Override
    public byte toByte() {
        switch (this.telematicInterworkingIndicator) {
            case NO_INTERWORKING: {
                return this.telematicInterworkingIndicator.value();
            }
            case INTERWORKING: {
                return (byte)(this.telematicInterworkingIndicator.value() | this.telematicDevice.value());
            }
        }
        throw new IllegalStateException("Telematic interworking indicator is not set");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtocolIdentifier00 that = (ProtocolIdentifier00)o;
        if (this.telematicDevice != that.telematicDevice) {
            return false;
        }
        return this.telematicInterworkingIndicator == that.telematicInterworkingIndicator;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.telematicInterworkingIndicator, this.telematicDevice});
    }
}

