/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.bean.pid;

import org.jsmpp.util.HexUtil;

public enum ProtocolMessageType {
    SM_TYPE_0(0),
    REPL_SM_TYPE_1(1),
    REPL_SM_TYPE_2(2),
    REPL_SM_TYPE_3(3),
    REPL_SM_TYPE_4(4),
    REPL_SM_TYPE_5(5),
    REPL_SM_TYPE_6(6),
    REPL_SM_TYPE_7(7),
    DEVICE_TRIGGERING_SM(8),
    ENHANCED_MESSAGE_SERVICE(30),
    RETURN_CALL_MESSAGE(31),
    ANSI_136_R_DATA(60),
    ME_DATA_DOWNLOAD(61),
    ME_DE_PERSONALIZATION_SM(62),
    USIM_DATA_DOWNLOAD(63);

    private byte value;

    private ProtocolMessageType(byte value) {
        this.value = value;
    }

    public static ProtocolMessageType valueOf(byte encoding) {
        for (ProtocolMessageType protocolMessageType : ProtocolMessageType.values()) {
            if (protocolMessageType.value != (encoding & 0x3F)) continue;
            return protocolMessageType;
        }
        throw new IllegalArgumentException("Could not recognize protocol messaging type from encoding '" + HexUtil.convertByteToHexString(encoding) + "'.");
    }

    public byte value() {
        return this.value;
    }
}

