/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jsmpp.bean.Bind;
import org.jsmpp.session.BindRequest;
import org.jsmpp.session.GenericServerResponseHandler;

class BindRequestReceiver {
    private final Lock lock = new ReentrantLock();
    private final Condition requestCondition = this.lock.newCondition();
    private final GenericServerResponseHandler responseHandler;
    private BindRequest request;
    private boolean alreadyWaitForRequest;

    BindRequestReceiver(GenericServerResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    BindRequest waitForRequest(long timeout) throws IllegalStateException, TimeoutException {
        this.lock.lock();
        try {
            if (this.alreadyWaitForRequest) {
                throw new IllegalStateException("waitForRequest(long) method already invoked");
            }
            if (this.request == null) {
                try {
                    this.requestCondition.await(timeout, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.request != null) {
                BindRequest bindRequest = this.request;
                return bindRequest;
            }
            throw new TimeoutException("No bind request after " + timeout + "ms");
        }
        finally {
            this.alreadyWaitForRequest = true;
            this.lock.unlock();
        }
    }

    void notifyAcceptBind(Bind bindParameter) throws IllegalStateException {
        block4: {
            this.lock.lock();
            try {
                if (this.request == null) {
                    this.request = new BindRequest(bindParameter, this.responseHandler);
                    this.requestCondition.signal();
                    break block4;
                }
                throw new IllegalStateException("Already waiting for acceptance bind");
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

