/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.IOException;
import org.jsmpp.bean.Command;
import org.jsmpp.session.ActivityNotifier;
import org.jsmpp.session.OutboundSMPPServerSessionContext;
import org.jsmpp.session.OutboundServerResponseHandler;
import org.jsmpp.util.HexUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PDUProcessOutboundServerTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(PDUProcessOutboundServerTask.class);
    private final Command pduHeader;
    private final byte[] pdu;
    private final OutboundSMPPServerSessionContext sessionContext;
    private final OutboundServerResponseHandler responseHandler;
    private final ActivityNotifier activityNotifier;
    private final Runnable onIOExceptionTask;

    PDUProcessOutboundServerTask(Command pduHeader, byte[] pdu, OutboundSMPPServerSessionContext sessionContext, OutboundServerResponseHandler responseHandler, ActivityNotifier activityNotifier, Runnable onIOExceptionTask) {
        this.pduHeader = pduHeader;
        this.pdu = pdu;
        this.sessionContext = sessionContext;
        this.responseHandler = responseHandler;
        this.activityNotifier = activityNotifier;
        this.onIOExceptionTask = onIOExceptionTask;
    }

    @Override
    public void run() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Received PDU {}", (Object)HexUtil.convertBytesToHexString(this.pdu, 0, this.pdu.length));
            }
            switch (this.pduHeader.getCommandId()) {
                case -2147483647: 
                case -2147483646: 
                case -2147483639: {
                    this.activityNotifier.notifyActivity();
                    this.sessionContext.getStateProcessor().processBindResp(this.sessionContext, this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483648: {
                    this.activityNotifier.notifyActivity();
                    this.sessionContext.getStateProcessor().processGenericNack(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 21: {
                    this.activityNotifier.notifyActivity();
                    this.sessionContext.getStateProcessor().processEnquireLink(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483627: {
                    this.activityNotifier.notifyActivity();
                    this.sessionContext.getStateProcessor().processEnquireLinkResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 5: {
                    this.activityNotifier.notifyActivity();
                    this.sessionContext.getStateProcessor().processDeliverSm(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 259: {
                    this.activityNotifier.notifyActivity();
                    this.sessionContext.getStateProcessor().processDataSm(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483389: {
                    this.activityNotifier.notifyActivity();
                    this.sessionContext.getStateProcessor().processDataSmResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 6: {
                    this.activityNotifier.notifyActivity();
                    this.sessionContext.getStateProcessor().processUnbind(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case -2147483642: {
                    this.activityNotifier.notifyActivity();
                    this.sessionContext.getStateProcessor().processUnbindResp(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                case 11: {
                    this.activityNotifier.notifyActivity();
                    this.sessionContext.getStateProcessor().processOutbind(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
                default: {
                    this.sessionContext.getStateProcessor().processUnknownCid(this.pduHeader, this.pdu, this.responseHandler);
                    break;
                }
            }
        }
        catch (IOException e) {
            this.onIOExceptionTask.run();
        }
    }
}

