/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session.state;

import java.io.IOException;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.OutboundServerResponseHandler;
import org.jsmpp.session.state.SMPPOutboundServerSessionBound;
import org.jsmpp.session.state.SMPPOutboundServerSessionState;
import org.jsmpp.util.DefaultDecomposer;
import org.jsmpp.util.PDUDecomposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SMPPOutboundServerSessionBoundRX
extends SMPPOutboundServerSessionBound
implements SMPPOutboundServerSessionState {
    private static final Logger logger = LoggerFactory.getLogger(SMPPOutboundServerSessionBoundRX.class);
    private static final PDUDecomposer pduDecomposer = new DefaultDecomposer();

    SMPPOutboundServerSessionBoundRX() {
    }

    @Override
    public SessionState getSessionState() {
        return SessionState.BOUND_RX;
    }

    @Override
    public void processDeliverSm(Command pduHeader, byte[] pdu, OutboundServerResponseHandler responseHandler) throws IOException {
        SMPPOutboundServerSessionBoundRX.processDeliverSm0(pduHeader, pdu, responseHandler);
    }

    static void processDeliverSm0(Command pduHeader, byte[] pdu, OutboundServerResponseHandler responseHandler) throws IOException {
        try {
            DeliverSm deliverSm = pduDecomposer.deliverSm(pdu);
            responseHandler.processDeliverSm(deliverSm);
            responseHandler.sendDeliverSmResp(0, pduHeader.getSequenceNumber(), deliverSm.getId());
        }
        catch (PDUStringException e) {
            logger.error("Failed decomposing deliver_sm", (Throwable)e);
            responseHandler.sendGenericNack(e.getErrorCode(), pduHeader.getSequenceNumber());
        }
        catch (ProcessRequestException e) {
            logger.error("Failed processing deliver_sm", (Throwable)e);
            responseHandler.sendDeliverSmResp(e.getErrorCode(), pduHeader.getSequenceNumber(), null);
        }
    }
}

