/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session.state;

import java.io.IOException;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.session.ResponseHandler;
import org.jsmpp.session.SMPPSessionContext;
import org.jsmpp.session.state.AbstractGenericSMPPSessionBound;
import org.jsmpp.session.state.SMPPSessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class SMPPSessionBound
extends AbstractGenericSMPPSessionBound
implements SMPPSessionState {
    private static final Logger log = LoggerFactory.getLogger(SMPPSessionBound.class);

    SMPPSessionBound() {
    }

    @Override
    public void processBindResp(SMPPSessionContext sessionContext, Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        responseHandler.sendNegativeResponse(pduHeader.getCommandId(), 5, pduHeader.getSequenceNumber());
    }

    static void processDeliverSm0(Command pduHeader, byte[] pdu, ResponseHandler responseHandler) throws IOException {
        try {
            DeliverSm deliverSm = pduDecomposer.deliverSm(pdu);
            responseHandler.processDeliverSm(deliverSm);
            responseHandler.sendDeliverSmResp(0, pduHeader.getSequenceNumber(), deliverSm.getId());
        }
        catch (PDUStringException e) {
            log.error("Failed decomposing deliver_sm", (Throwable)e);
            responseHandler.sendGenericNack(e.getErrorCode(), pduHeader.getSequenceNumber());
        }
        catch (ProcessRequestException e) {
            log.error("Failed processing deliver_sm", (Throwable)e);
            responseHandler.sendDeliverSmResp(e.getErrorCode(), pduHeader.getSequenceNumber(), null);
        }
    }
}

