/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import org.jsmpp.util.OctetUtil;

class SequentialBytesReader {
    int cursor;
    private byte[] bytes;

    public SequentialBytesReader(byte[] bytes) {
        this.bytes = bytes;
        this.cursor = 0;
    }

    public byte readByte() {
        return this.bytes[this.cursor++];
    }

    public int readInt() {
        int val = OctetUtil.bytesToInt(this.bytes, this.cursor);
        this.cursor += 4;
        return val;
    }

    public byte[] readBytesUntilNull() {
        int i = this.cursor;
        while (this.bytes[i++] != 0) {
        }
        int length = i - 1 - this.cursor;
        if (length == 0) {
            this.cursor += 1 + length;
            return new byte[0];
        }
        byte[] data = new byte[length];
        System.arraycopy(this.bytes, this.cursor, data, 0, length);
        this.cursor += 1 + length;
        return data;
    }

    public String readCString() {
        int i = this.cursor;
        while (this.bytes[i++] != 0) {
        }
        int length = i - 1 - this.cursor;
        if (length == 0) {
            this.cursor += 1 + length;
            return null;
        }
        String val = new String(this.bytes, this.cursor, length);
        this.cursor += 1 + length;
        return val;
    }

    public byte[] readBytes(int length) {
        if (length == 0) {
            return new byte[0];
        }
        byte[] data = new byte[length];
        System.arraycopy(this.bytes, this.cursor, data, 0, length);
        this.cursor += length;
        return data;
    }

    public byte[] readBytes(byte length) {
        return this.readBytes(length & 0xFF);
    }

    public String readString(int length) {
        if (length == 0) {
            return null;
        }
        String val = new String(this.bytes, this.cursor, length);
        this.cursor += length;
        return val;
    }

    public short readShort() {
        short value = OctetUtil.bytesToShort(this.bytes, this.cursor);
        this.cursor += 2;
        return value;
    }

    public String readString(byte length) {
        return this.readString(length & 0xFF);
    }

    public int remainBytesLength() {
        return this.bytes.length - this.cursor;
    }

    public boolean hasMoreBytes() {
        return this.cursor < this.bytes.length - 1;
    }

    public void resetCursor() {
        this.cursor = 0;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

