/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class SolrEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":url";
    private static final String[] SCHEMES = new String[]{"solr", "solrs", "solrCloud"};
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;
    private static final Set<String> MULTI_VALUE_PREFIXES;

    @Override
    public boolean isEnabled(String scheme) {
        for (String s : SCHEMES) {
            if (!s.equals(scheme)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax = scheme + BASE;
        Object uri = syntax;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, (String)uri, "url", null, true, copy);
        uri = this.buildQueryParameters((String)uri, copy, encode);
        return uri;
    }

    @Override
    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    @Override
    public Set<String> multiValuePrefixes() {
        return MULTI_VALUE_PREFIXES;
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(20);
        props.add("allowCompression");
        props.add("autoCommit");
        props.add("collection");
        props.add("connectionTimeout");
        props.add("defaultMaxConnectionsPerHost");
        props.add("followRedirects");
        props.add("httpClient");
        props.add("lazyStartProducer");
        props.add("maxRetries");
        props.add("maxTotalConnections");
        props.add("password");
        props.add("requestHandler");
        props.add("soTimeout");
        props.add("solrClient");
        props.add("streamingQueueSize");
        props.add("streamingThreadCount");
        props.add("url");
        props.add("username");
        props.add("zkChroot");
        props.add("zkHost");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
        MULTI_VALUE_PREFIXES = Collections.emptySet();
    }
}

