/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.ml.clustering.Cluster;
import org.apache.commons.math3.ml.clustering.Clusterable;
import org.apache.commons.math3.ml.clustering.DBSCANClusterer;
import org.apache.commons.math3.ml.distance.DistanceMeasure;
import org.apache.commons.math3.ml.distance.EuclideanDistance;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class DbscanEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public DbscanEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        Matrix matrix = null;
        double e = 0.0;
        int minPoints = 1;
        DistanceMeasure distanceMeasure = new EuclideanDistance();
        if (values.length < 3 || values.length > 4) {
            throw new IOException("The dbscan scan function requires 3 or 4 parameters.");
        }
        if (!(values[0] instanceof Matrix)) {
            throw new IOException("The first parameter for dbscan should be the observation matrix.");
        }
        matrix = (Matrix)values[0];
        if (!(values[1] instanceof Number)) {
            throw new IOException("The second parameter for dbscan should be e.");
        }
        e = ((Number)values[1]).doubleValue();
        if (!(values[2] instanceof Number)) {
            throw new IOException("The third parameter for dbscan should be minPoints.");
        }
        minPoints = ((Number)values[2]).intValue();
        if (values.length > 3) {
            distanceMeasure = (DistanceMeasure)values[3];
        }
        DBSCANClusterer dbscan = new DBSCANClusterer(e, minPoints, distanceMeasure);
        ArrayList<ClusterPoint> points = new ArrayList<ClusterPoint>();
        double[][] data = matrix.getData();
        List<String> ids = matrix.getRowLabels();
        for (int i = 0; i < data.length; ++i) {
            double[] vec = data[i];
            if (ids != null) {
                points.add(new ClusterPoint(ids.get(i), vec));
                continue;
            }
            points.add(new ClusterPoint(Integer.toString(i), vec));
        }
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("e", e);
        fields.put("minPoints", minPoints);
        fields.put("distance", distanceMeasure.toString());
        return new ClusterTuple(fields, dbscan.cluster(points), matrix.getColumnLabels());
    }

    public static class ClusterTuple
    extends Tuple {
        private List<String> columnLabels;
        private List<Cluster<ClusterPoint>> clusters;

        public ClusterTuple(Map<String, Object> fields, List<Cluster<ClusterPoint>> clusters, List<String> columnLabels) {
            super(fields);
            this.clusters = clusters;
            this.columnLabels = columnLabels;
        }

        public List<String> getColumnLabels() {
            return this.columnLabels;
        }

        public List<Cluster<ClusterPoint>> getClusters() {
            return this.clusters;
        }
    }

    public static class ClusterPoint
    implements Clusterable {
        private double[] point;
        private String id;

        public ClusterPoint(String id, double[] point) {
            this.id = id;
            this.point = point;
        }

        @Override
        public double[] getPoint() {
            return this.point;
        }

        public String getId() {
            return this.id;
        }
    }
}

