/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import org.apache.camel.component.solr.SolrClientHandler;
import org.apache.camel.component.solr.SolrConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;

public class SolrClientHandlerConcurrentUpdate
extends SolrClientHandler {
    public SolrClientHandlerConcurrentUpdate(SolrConfiguration solrConfiguration) {
        super(solrConfiguration);
    }

    @Override
    protected SolrClient getSolrClient() {
        ConcurrentUpdateSolrClient.Builder builder = new ConcurrentUpdateSolrClient.Builder(this.getFirstUrlFromList());
        if (!ObjectHelper.isEmpty(this.solrConfiguration.getConnectionTimeout())) {
            builder.withConnectionTimeout(this.solrConfiguration.getConnectionTimeout());
        }
        if (!ObjectHelper.isEmpty(this.solrConfiguration.getSoTimeout())) {
            builder.withSocketTimeout(this.solrConfiguration.getSoTimeout());
        }
        if (!ObjectHelper.isEmpty(this.solrConfiguration.getHttpClient())) {
            builder.withHttpClient(this.solrConfiguration.getHttpClient());
        }
        builder.withQueueSize(this.solrConfiguration.getStreamingQueueSize());
        builder.withThreadCount(this.solrConfiguration.getStreamingThreadCount());
        return builder.build();
    }
}

