/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.UpdateCollectionPropertyRequestBody;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class CollectionPropertiesApi {

    public static class DeleteCollectionProperty
    extends SolrRequest<DeleteCollectionPropertyResponse> {
        private final String collName;
        private final String propName;

        public DeleteCollectionProperty(String collName, String propName) {
            super(SolrRequest.METHOD.valueOf("DELETE"), "/collections/{collName}/properties/{propName}".replace("{collName}", collName).replace("{propName}", propName));
            this.collName = collName;
            this.propName = propName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected DeleteCollectionPropertyResponse createResponse(SolrClient client) {
            return new DeleteCollectionPropertyResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class DeleteCollectionPropertyResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public DeleteCollectionPropertyResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class CreateOrUpdateCollectionProperty
    extends SolrRequest<CreateOrUpdateCollectionPropertyResponse> {
        private final UpdateCollectionPropertyRequestBody requestBody;
        private final String collName;
        private final String propName;

        public CreateOrUpdateCollectionProperty(String collName, String propName) {
            super(SolrRequest.METHOD.valueOf("PUT"), "/collections/{collName}/properties/{propName}".replace("{collName}", collName).replace("{propName}", propName));
            this.collName = collName;
            this.propName = propName;
            this.requestBody = new UpdateCollectionPropertyRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setValue(String value) {
            this.requestBody.value = value;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected CreateOrUpdateCollectionPropertyResponse createResponse(SolrClient client) {
            return new CreateOrUpdateCollectionPropertyResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class CreateOrUpdateCollectionPropertyResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public CreateOrUpdateCollectionPropertyResponse() {
            super(SolrJerseyResponse.class);
        }
    }
}

