/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import org.apache.camel.component.solr.SolrClientHandler;
import org.apache.camel.component.solr.SolrConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;

public class SolrClientHandlerLbHttp
extends SolrClientHandler {
    public SolrClientHandlerLbHttp(SolrConfiguration solrConfiguration) {
        super(solrConfiguration);
    }

    @Override
    protected SolrClient getSolrClient() {
        LBHttpSolrClient.Builder builder = new LBHttpSolrClient.Builder();
        for (String serverUrl : SolrClientHandlerLbHttp.getUrlListFrom(this.solrConfiguration)) {
            builder.withBaseSolrUrl(serverUrl);
        }
        if (!ObjectHelper.isEmpty(this.solrConfiguration.getConnectionTimeout())) {
            builder.withConnectionTimeout(this.solrConfiguration.getConnectionTimeout());
        }
        if (!ObjectHelper.isEmpty(this.solrConfiguration.getSoTimeout())) {
            builder.withSocketTimeout(this.solrConfiguration.getSoTimeout());
        }
        if (!ObjectHelper.isEmpty(this.solrConfiguration.getHttpClient())) {
            builder.withHttpClient(this.solrConfiguration.getHttpClient());
        }
        return builder.build();
    }
}

