/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import jakarta.activation.MimetypesFileTypeMap;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.Exchange;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.WrappedFile;
import org.apache.camel.component.solr.SolrConfiguration;
import org.apache.camel.component.solr.SolrEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.request.AbstractUpdateRequest;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.DirectXmlRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;

public class SolrProducer
extends DefaultProducer {
    public SolrProducer(SolrEndpoint endpoint) {
        super(endpoint);
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String operation = exchange.getIn().getHeader("SolrOperation", String.class);
        if (operation == null) {
            throw new NoSuchHeaderException(exchange, "SolrOperation", String.class);
        }
        SolrConfiguration solrConfiguration = this.getEndpoint().getSolrConfiguration(operation);
        SolrClient solrClient = exchange.getIn().getHeader("CamelSolrClient", SolrClient.class);
        if (solrClient == null) {
            solrClient = this.getEndpoint().getComponent().getSolrClient(this, solrConfiguration);
        }
        ModifiableSolrParams solrParams = new ModifiableSolrParams();
        for (Map.Entry<String, Object> entry : exchange.getIn().getHeaders().entrySet()) {
            if (!entry.getKey().startsWith("SolrParam.")) continue;
            String paramName = entry.getKey().substring("SolrParam.".length());
            solrParams.add(paramName, entry.getValue().toString());
        }
        String solrCollection = exchange.getIn().getHeader("CamelSolrCollection", String.class);
        if (operation.equalsIgnoreCase("INSERT")) {
            this.insert(exchange, solrClient, solrConfiguration, solrParams);
            if (solrConfiguration.isAutoCommit()) {
                this.commit(exchange, solrClient, solrConfiguration, solrParams);
            }
        } else if (operation.equalsIgnoreCase("INSERT_STREAMING")) {
            this.insert(exchange, solrClient, solrConfiguration, solrParams);
            if (solrConfiguration.isAutoCommit()) {
                this.commit(exchange, solrClient, solrConfiguration, solrParams);
            }
        } else if (operation.equalsIgnoreCase("DELETE_BY_ID")) {
            updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
            updateRequest.deleteById(exchange.getIn().getBody(String.class));
            updateRequest.process(solrClient, solrCollection);
            if (solrConfiguration.isAutoCommit()) {
                this.commit(exchange, solrClient, solrConfiguration, solrParams);
            }
        } else if (operation.equalsIgnoreCase("DELETE_BY_QUERY")) {
            updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
            updateRequest.deleteByQuery(exchange.getIn().getBody(String.class));
            updateRequest.process(solrClient, solrCollection);
            if (solrConfiguration.isAutoCommit()) {
                this.commit(exchange, solrClient, solrConfiguration, solrParams);
            }
        } else if (operation.equalsIgnoreCase("ADD_BEAN")) {
            updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
            updateRequest.add(solrClient.getBinder().toSolrInputDocument(exchange.getIn().getBody()));
            updateRequest.process(solrClient, solrCollection);
            if (solrConfiguration.isAutoCommit()) {
                this.commit(exchange, solrClient, solrConfiguration, solrParams);
            }
        } else if (operation.equalsIgnoreCase("ADD_BEANS")) {
            updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
            Collection body = exchange.getIn().getBody(Collection.class);
            updateRequest.add(body.stream().map(solrClient.getBinder()::toSolrInputDocument).collect(Collectors.toList()));
            updateRequest.process(solrClient, solrCollection);
            if (solrConfiguration.isAutoCommit()) {
                this.commit(exchange, solrClient, solrConfiguration, solrParams);
            }
        } else if (operation.equalsIgnoreCase("COMMIT")) {
            this.commit(exchange, solrClient, solrConfiguration, solrParams);
        } else if (operation.equalsIgnoreCase("SOFT_COMMIT")) {
            this.commit(exchange, solrClient, solrConfiguration, solrParams, true);
        } else if (operation.equalsIgnoreCase("ROLLBACK")) {
            updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
            updateRequest.rollback();
            updateRequest.process(solrClient, solrCollection);
            if (solrConfiguration.isAutoCommit()) {
                this.commit(exchange, solrClient, solrConfiguration, solrParams);
            }
        } else if (operation.equalsIgnoreCase("OPTIMIZE")) {
            updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
            updateRequest.setAction(AbstractUpdateRequest.ACTION.OPTIMIZE, true, true, 1);
            updateRequest.process(solrClient, solrCollection);
            if (solrConfiguration.isAutoCommit()) {
                this.commit(exchange, solrClient, solrConfiguration, solrParams);
            }
        } else if (operation.equalsIgnoreCase("QUERY")) {
            this.query(exchange, solrClient, solrConfiguration, solrParams);
        } else {
            throw new IllegalArgumentException("SolrOperation header value '" + operation + "' is not supported");
        }
    }

    private void commit(Exchange exchange, SolrClient solrClient, SolrConfiguration solrConfiguration, ModifiableSolrParams solrParams) throws SolrServerException, IOException {
        this.commit(exchange, solrClient, solrConfiguration, solrParams, false);
    }

    private void commit(Exchange exchange, SolrClient solrClient, SolrConfiguration solrConfiguration, ModifiableSolrParams solrParams, boolean softCommit) throws SolrServerException, IOException {
        String solrCollection = exchange.getIn().getHeader("CamelSolrCollection", String.class);
        UpdateRequest updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
        updateRequest.setAction(AbstractUpdateRequest.ACTION.COMMIT, solrParams.getBool("waitFlush", true), solrParams.getBool("waitSearcher", true), softCommit);
        updateRequest.process(solrClient, solrCollection);
    }

    private void query(Exchange exchange, SolrClient solrClient, SolrConfiguration solrConfiguration, ModifiableSolrParams solrParams) throws SolrServerException, IOException, NoSuchHeaderException {
        String solrCollection = exchange.getIn().getHeader("CamelSolrCollection", String.class);
        SolrQuery solrQuery = new SolrQuery();
        if (!ObjectHelper.isNotEmpty(exchange.getMessage().getHeader("CamelSolrQueryString"))) {
            throw new NoSuchHeaderException(exchange, "CamelSolrQueryString", String.class);
        }
        solrQuery.setQuery(exchange.getMessage().getHeader("CamelSolrQueryString", String.class));
        solrQuery.add(solrParams);
        QueryRequest queryRequest = new QueryRequest(solrQuery);
        queryRequest.setBasicAuthCredentials(solrConfiguration.getUsername(), solrConfiguration.getPassword());
        QueryResponse p = (QueryResponse)queryRequest.process(solrClient, solrCollection);
        exchange.getMessage().setBody(p.getResults());
    }

    private void insert(Exchange exchange, SolrClient solrClient, SolrConfiguration solrConfiguration, ModifiableSolrParams solrParams) throws Exception {
        String solrCollection = exchange.getIn().getHeader("CamelSolrCollection", String.class);
        Object body = exchange.getIn().getBody();
        boolean invalid = false;
        if (body instanceof WrappedFile) {
            body = ((WrappedFile)body).getFile();
        }
        if (ObjectHelper.isNotEmpty(exchange.getIn().getHeader("Content-Type", String.class))) {
            String mimeType = exchange.getIn().getHeader("Content-Type", String.class);
            ContentStreamUpdateRequest updateRequest = new ContentStreamUpdateRequest(this.getRequestHandler(solrConfiguration));
            updateRequest.setParams(solrParams);
            updateRequest.setBasicAuthCredentials(solrConfiguration.getUsername(), solrConfiguration.getPassword());
            updateRequest.addFile((File)body, mimeType);
            updateRequest.process(solrClient, solrCollection);
        } else if (body instanceof File) {
            MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap();
            String mimeType = mimeTypesMap.getContentType((File)body);
            ContentStreamUpdateRequest updateRequest = new ContentStreamUpdateRequest(this.getRequestHandler(solrConfiguration));
            updateRequest.setParams(solrParams);
            updateRequest.setBasicAuthCredentials(solrConfiguration.getUsername(), solrConfiguration.getPassword());
            updateRequest.addFile((File)body, mimeType);
            updateRequest.process(solrClient, solrCollection);
        } else if (body instanceof SolrInputDocument) {
            UpdateRequest updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
            updateRequest.add((SolrInputDocument)body);
            updateRequest.process(solrClient, solrCollection);
        } else if (body instanceof List) {
            List list = (List)body;
            if (!list.isEmpty() && list.get(0) instanceof SolrInputDocument) {
                UpdateRequest updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
                updateRequest.add(list);
                updateRequest.process(solrClient, solrCollection);
            } else {
                invalid = true;
            }
        } else {
            boolean hasSolrHeaders = false;
            for (Map.Entry<String, Object> entry : exchange.getIn().getHeaders().entrySet()) {
                if (!entry.getKey().startsWith("SolrField.")) continue;
                hasSolrHeaders = true;
                break;
            }
            if (hasSolrHeaders) {
                updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
                doc = new SolrInputDocument();
                for (Map.Entry<String, Object> entry : exchange.getIn().getHeaders().entrySet()) {
                    if (!entry.getKey().startsWith("SolrField.")) continue;
                    String fieldName = entry.getKey().substring("SolrField.".length());
                    doc.setField(fieldName, entry.getValue());
                }
                ((UpdateRequest)updateRequest).add(doc);
                ((SolrRequest)updateRequest).process(solrClient, solrCollection);
            } else if (body instanceof String) {
                Object bodyAsString = (String)body;
                if (!((String)bodyAsString).startsWith("<add")) {
                    bodyAsString = "<add>" + (String)bodyAsString + "</add>";
                }
                DirectXmlRequest xmlRequest = new DirectXmlRequest(this.getRequestHandler(solrConfiguration), (String)bodyAsString);
                xmlRequest.setParams(solrParams);
                xmlRequest.setBasicAuthCredentials(solrConfiguration.getUsername(), solrConfiguration.getPassword());
                xmlRequest.process(solrClient, solrCollection);
            } else if (body instanceof Map) {
                updateRequest = this.createUpdateRequest(solrConfiguration, solrParams);
                doc = new SolrInputDocument();
                Map bodyMap = (Map)body;
                for (Map.Entry entry : bodyMap.entrySet()) {
                    doc.setField((String)entry.getKey(), entry.getValue());
                }
                ((UpdateRequest)updateRequest).add(doc);
                ((SolrRequest)updateRequest).process(solrClient, solrCollection);
            } else {
                invalid = true;
            }
        }
        if (invalid) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unable to find data in Exchange to update Solr");
        }
    }

    private String getRequestHandler(SolrConfiguration solrConfiguration) {
        String requestHandler = solrConfiguration.getRequestHandler();
        return requestHandler == null ? "/update" : requestHandler;
    }

    private UpdateRequest createUpdateRequest(SolrConfiguration solrConfiguration, ModifiableSolrParams solrParams) {
        UpdateRequest updateRequest = new UpdateRequest(this.getRequestHandler(solrConfiguration));
        updateRequest.setParams(solrParams);
        updateRequest.setBasicAuthCredentials(solrConfiguration.getUsername(), solrConfiguration.getPassword());
        return updateRequest;
    }

    @Override
    public SolrEndpoint getEndpoint() {
        return (SolrEndpoint)super.getEndpoint();
    }

    @Override
    protected void doShutdown() throws Exception {
        this.getEndpoint().onProducerShutdown(this);
    }
}

