/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.util.Collection;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecFactory;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.NetscapeDomainHandler;
import org.apache.http.impl.cookie.NetscapeDraftSpec;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class SolrPortAwareCookieSpecFactory
implements CookieSpecFactory,
CookieSpecProvider {
    public static final String POLICY_NAME = "solr-portaware";
    private final CookieSpec cookieSpec;

    public SolrPortAwareCookieSpecFactory(String[] datepatterns) {
        this.cookieSpec = new PortAwareCookieSpec(datepatterns);
    }

    public SolrPortAwareCookieSpecFactory() {
        this(null);
    }

    @Override
    public CookieSpec newInstance(HttpParams params) {
        if (params != null) {
            String[] patterns = null;
            Collection param = (Collection)params.getParameter("http.protocol.cookie-datepatterns");
            if (param != null) {
                patterns = new String[param.size()];
                patterns = param.toArray(patterns);
            }
            return new PortAwareCookieSpec(patterns);
        }
        return new PortAwareCookieSpec(null);
    }

    @Override
    public CookieSpec create(HttpContext context) {
        return this.cookieSpec;
    }

    public static class PortAwareDomainHandler
    extends NetscapeDomainHandler {
        @Override
        public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
            String domain;
            String hostPort;
            if (origin != null && origin.getHost() != null && cookie != null && (hostPort = origin.getHost() + ":" + origin.getPort()).equals(domain = cookie.getDomain())) {
                return;
            }
            super.validate(cookie, origin);
        }

        @Override
        public boolean match(Cookie cookie, CookieOrigin origin) {
            String domain;
            String hostPort;
            if (origin != null && origin.getHost() != null && cookie != null && (hostPort = origin.getHost() + ":" + origin.getPort()).equals(domain = cookie.getDomain())) {
                return true;
            }
            return super.match(cookie, origin);
        }
    }

    public static class PortAwareCookieSpec
    extends NetscapeDraftSpec {
        public PortAwareCookieSpec(String[] patterns) {
            super(patterns);
            super.registerAttribHandler("domain", new PortAwareDomainHandler());
        }

        public PortAwareCookieSpec() {
            this((String[])null);
        }
    }
}

