/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.util.CollectionUtil;

public class Tuple
implements Cloneable,
MapWriter {
    public boolean EOF;
    public boolean EXCEPTION;
    private final Map<String, Object> fields = CollectionUtil.newHashMap(2);
    private List<String> fieldNames;
    private Map<String, String> fieldLabels;

    public Tuple() {
    }

    public Tuple(String k1, Object v1) {
        if (k1 != null) {
            this.put(k1, v1);
        }
    }

    public Tuple(String k1, Object v1, String k2, Object v2) {
        if (k1 != null) {
            this.put(k1, v1);
        }
        if (k2 != null) {
            this.put(k2, v2);
        }
    }

    public Tuple(Map<String, ?> fields) {
        this.putAll(fields);
    }

    public Tuple(Tuple original) {
        this.putAll(original.fields);
        if (original.fieldNames != null) {
            this.fieldNames = new ArrayList<String>(original.fieldNames);
        }
        if (original.fieldLabels != null) {
            this.fieldLabels = new HashMap<String, String>(original.fieldLabels);
        }
    }

    public Object get(String key) {
        return this.fields.get(key);
    }

    public void put(String key, Object value) {
        this.fields.put(key, value);
        if (key.equals("EOF")) {
            this.EOF = true;
        } else if (key.equals("EXCEPTION")) {
            this.EXCEPTION = true;
        }
    }

    public void putAll(Map<String, ?> fields) {
        this.fields.putAll(fields);
        if (fields.containsKey("EOF")) {
            this.EOF = true;
        }
        if (fields.containsKey("EXCEPTION")) {
            this.EXCEPTION = true;
        }
    }

    public void remove(String key) {
        this.fields.remove(key);
    }

    public String getString(String key) {
        return String.valueOf(this.fields.get(key));
    }

    public String getException() {
        return (String)this.fields.get("EXCEPTION");
    }

    public Long getLong(String key) {
        Object o = this.fields.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return Long.parseLong(o.toString());
    }

    public Boolean getBool(String key) {
        Object o = this.fields.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return Boolean.parseBoolean(o.toString());
    }

    public List<Boolean> getBools(String key) {
        return (List)this.fields.get(key);
    }

    public Date getDate(String key) {
        Object o = this.fields.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        return new Date(Instant.parse(o.toString()).toEpochMilli());
    }

    public List<Date> getDates(String key) {
        List vals = (List)this.fields.get(key);
        if (vals == null) {
            return null;
        }
        ArrayList<Date> ret = new ArrayList<Date>();
        for (String dateStr : (List)this.fields.get(key)) {
            ret.add(new Date(Instant.parse(dateStr).toEpochMilli()));
        }
        return ret;
    }

    public Double getDouble(String key) {
        Object o = this.fields.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        return Double.parseDouble(o.toString());
    }

    public List<String> getStrings(String key) {
        return (List)this.fields.get(key);
    }

    public List<Long> getLongs(String key) {
        return (List)this.fields.get(key);
    }

    public List<Double> getDoubles(String key) {
        return (List)this.fields.get(key);
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public Map<String, String> getFieldLabels() {
        return this.fieldLabels;
    }

    public void setFieldLabels(Map<String, String> fieldLabels) {
        this.fieldLabels = fieldLabels;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(List<String> fieldNames) {
        this.fieldNames = fieldNames;
    }

    public List<Map<?, ?>> getMaps(String key) {
        return (List)this.fields.get(key);
    }

    public void setMaps(String key, List<Map<?, ?>> maps) {
        this.fields.put(key, maps);
    }

    public Map<String, Map<?, ?>> getMetrics() {
        return (Map)this.fields.get("_METRICS_");
    }

    public void setMetrics(Map<String, Map<?, ?>> metrics) {
        this.fields.put("_METRICS_", metrics);
    }

    public Tuple clone() {
        return new Tuple(this);
    }

    public void merge(Tuple other) {
        this.putAll(other.getFields());
        if (other.fieldNames != null) {
            if (this.fieldNames != null) {
                this.fieldNames.addAll(other.fieldNames.stream().filter(otherFieldName -> !this.fieldNames.contains(otherFieldName)).collect(Collectors.toList()));
            } else {
                this.fieldNames = new ArrayList<String>(other.fieldNames);
            }
        }
        if (other.fieldLabels != null) {
            if (this.fieldLabels != null) {
                this.fieldLabels.putAll(other.fieldLabels);
            } else {
                this.fieldLabels = new HashMap<String, String>(other.fieldLabels);
            }
        }
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        if (this.fieldNames == null) {
            this.fields.forEach((k, v) -> {
                try {
                    ew.put((CharSequence)k, v);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        } else {
            for (String fieldName : this.fieldNames) {
                String label = this.fieldLabels.get(fieldName);
                ew.put((CharSequence)label, this.fields.get(label));
            }
        }
    }

    public static Tuple EOF() {
        Tuple tuple = new Tuple();
        tuple.put("EOF", true);
        return tuple;
    }

    public static Tuple EXCEPTION(String msg, boolean isEOF) {
        Tuple tuple = new Tuple();
        tuple.put("EXCEPTION", msg);
        if (isEOF) {
            tuple.put("EOF", true);
        }
        return tuple;
    }

    public static Tuple EXCEPTION(Throwable t, boolean isEOF) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        return Tuple.EXCEPTION(sw.toString(), isEOF);
    }
}

