/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.math3.analysis.function.HarmonicOscillator;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.eval.VectorFunction;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class OscillateEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public OscillateEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Object doWork(Object ... objects) throws IOException {
        if (objects.length != 3) {
            throw new IOException("The oscillate function takes 3 arguments.");
        }
        double amp = ((Number)objects[0]).doubleValue();
        double om = ((Number)objects[1]).doubleValue();
        double phase = ((Number)objects[2]).doubleValue();
        HarmonicOscillator pf = new HarmonicOscillator(amp, om, phase);
        double[] x = new double[128];
        ArrayList<Double> list = new ArrayList<Double>();
        for (int i = 0; i < 128; ++i) {
            double yvalue = pf.value(i);
            list.add(yvalue);
            x[i] = i;
        }
        VectorFunction func = new VectorFunction((Object)pf, list);
        func.addToContext("x", x);
        return func;
    }
}

