/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.io.stream.UpdateStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.common.SolrInputDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeleteStream
extends UpdateStream
implements Expressible {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ID_TUPLE_KEY = "id";

    public DeleteStream(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        Explanation explanation = super.toExplanation(factory);
        explanation.setExpression("Delete docs from " + this.getCollectionName());
        return explanation;
    }

    @Override
    protected boolean defaultPruneVersionField() {
        return false;
    }

    @Override
    protected void uploadBatchToCollection(List<SolrInputDocument> documentBatch) throws IOException {
        if (documentBatch.size() == 0) {
            return;
        }
        try {
            UpdateRequest req = new UpdateRequest();
            for (SolrInputDocument doc : documentBatch) {
                String id = doc.getFieldValue(ID_TUPLE_KEY).toString();
                Long version = DeleteStream.getVersion(doc);
                req.deleteById(id, version);
            }
            CloudSolrClient cloudSolrClient = this.clientCache.getCloudSolrClient(this.zkHost);
            req.process(cloudSolrClient, this.getCollectionName());
        }
        catch (IOException | NumberFormatException | SolrServerException e) {
            log.warn("Unable to delete documents from collection due to unexpected error.", (Throwable)e);
            String className = e.getClass().getName();
            String message = e.getMessage();
            throw new IOException(String.format(Locale.ROOT, "Unexpected error when deleting documents from collection %s- %s:%s", this.getCollectionName(), className, message));
        }
    }

    private static Long getVersion(SolrInputDocument doc) throws NumberFormatException {
        if (!doc.containsKey("_version_")) {
            return null;
        }
        Object v = doc.getFieldValue("_version_");
        if (null == v) {
            return null;
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        return Long.parseLong(v.toString());
    }
}

