/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.SolrStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class SqlStream
extends TupleStream
implements Expressible {
    private static final long serialVersionUID = 1L;
    protected String zkHost;
    protected String collection;
    protected SolrParams params;
    protected transient TupleStream tupleStream;
    protected transient StreamContext streamContext;

    public SqlStream(String zkHost, String collectionName, SolrParams params) throws IOException {
        this.init(collectionName, zkHost, params);
    }

    public SqlStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        if (null == collectionName) {
            collectionName = factory.getDefaultCollection();
        }
        if (0 == namedParams.size()) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - at least one named parameter expected. eg. 'q=*:*'", expression));
        }
        ModifiableSolrParams mParams = new ModifiableSolrParams();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost") || namedParam.getName().equals("aliases")) continue;
            mParams.add(namedParam.getName(), namedParam.getParameter().toString().trim());
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        this.init(collectionName, zkHost, mParams);
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        expression.addParameter(this.collection);
        for (Map.Entry<String, String[]> param : this.params) {
            String value = String.join((CharSequence)",", param.getValue());
            value = value.replace("\"", "\\\"");
            expression.addParameter(new StreamExpressionNamedParameter(param.getKey(), value));
        }
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-source");
        explanation.setExpression(this.toExpression(factory).toString());
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        child.setFunctionName(String.format(Locale.ROOT, "solr (%s)", this.collection));
        child.setImplementingClass("Solr/Lucene");
        child.setExpressionType("datastore");
        if (null != this.params) {
            ModifiableSolrParams mParams = new ModifiableSolrParams(this.params);
            child.setExpression(mParams.getMap().entrySet().stream().map(e -> String.format(Locale.ROOT, "%s=%s", e.getKey(), Arrays.toString((Object[])e.getValue()))).collect(Collectors.joining(",")));
        }
        explanation.addChild(child);
        return explanation;
    }

    protected void init(String collectionName, String zkHost, SolrParams params) throws IOException {
        this.zkHost = zkHost;
        this.collection = collectionName;
        this.params = new ModifiableSolrParams(params);
        if (params.get("stmt") == null) {
            throw new IOException("stmt param expected for sql function");
        }
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.streamContext = context;
    }

    @Override
    public void open() throws IOException {
        this.constructStream();
        this.tupleStream.open();
    }

    @Override
    public List<TupleStream> children() {
        return null;
    }

    protected void constructStream() throws IOException {
        try {
            List<String> shardUrls = SqlStream.getShards(this.zkHost, this.collection, this.streamContext);
            Collections.shuffle(shardUrls, new Random());
            String url = shardUrls.get(0);
            ModifiableSolrParams mParams = new ModifiableSolrParams(this.params);
            mParams.add("qt", "/sql");
            this.tupleStream = new SolrStream(url, mParams);
            if (this.streamContext != null) {
                this.tupleStream.setStreamContext(this.streamContext);
                if (this.streamContext.isLocal()) {
                    mParams.add("distrib", "false");
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.tupleStream.close();
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    @Override
    public Tuple read() throws IOException {
        return this.tupleStream.read();
    }
}

