/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.apache.solr.cluster.api.ApiType;
import org.apache.solr.cluster.api.CollectionConfig;
import org.apache.solr.cluster.api.HashRange;
import org.apache.solr.cluster.api.Resource;
import org.apache.solr.cluster.api.Router;
import org.apache.solr.cluster.api.Shard;
import org.apache.solr.cluster.api.ShardReplica;
import org.apache.solr.cluster.api.SimpleMap;
import org.apache.solr.cluster.api.SolrCluster;
import org.apache.solr.cluster.api.SolrCollection;
import org.apache.solr.cluster.api.SolrNode;
import org.apache.solr.common.SimpleZkMap;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.Utils;
import org.apache.solr.common.util.WrappedSimpleMap;
import org.apache.zookeeper.KeeperException;

public class LazySolrCluster
implements SolrCluster {
    final ZkStateReader zkStateReader;
    private final Map<String, SolrCollectionImpl> cached = new ConcurrentHashMap<String, SolrCollectionImpl>();
    private final SimpleMap<SolrCollection> collections;
    private final SimpleMap<SolrCollection> collectionsAndAliases;
    private final SimpleMap<SolrNode> nodes;
    private SimpleMap<CollectionConfig> configs;

    public LazySolrCluster(ZkStateReader zkStateReader) {
        this.zkStateReader = zkStateReader;
        this.collections = this.lazyCollectionsMap(zkStateReader);
        this.collectionsAndAliases = this.lazyCollectionsWithAlias(zkStateReader);
        this.nodes = this.lazyNodeMap();
    }

    private SimpleMap<CollectionConfig> lazyConfigMap() {
        final HashSet configNames = new HashSet();
        new SimpleZkMap(this.zkStateReader, "/configs").abortableForEach((BiFunction<String, ? super Resource, Boolean>)((BiFunction<String, Resource, Boolean>)(name, resource) -> {
            if (!name.contains("/")) {
                configNames.add(name);
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }));
        return new SimpleMap<CollectionConfig>(){

            @Override
            public CollectionConfig get(String key) {
                if (configNames.contains(key)) {
                    return new ConfigImpl(key);
                }
                return null;
            }

            @Override
            public void forEachEntry(BiConsumer<String, ? super CollectionConfig> fun) {
                for (String name : configNames) {
                    fun.accept(name, new ConfigImpl(name));
                }
            }

            @Override
            public int size() {
                return configNames.size();
            }
        };
    }

    private SimpleMap<SolrNode> lazyNodeMap() {
        return new SimpleMap<SolrNode>(){

            @Override
            public SolrNode get(String key) {
                if (!LazySolrCluster.this.zkStateReader.getClusterState().liveNodesContain(key)) {
                    return null;
                }
                return new Node(key);
            }

            @Override
            public void forEachEntry(BiConsumer<String, ? super SolrNode> fun) {
                for (String s : LazySolrCluster.this.zkStateReader.getClusterState().getLiveNodes()) {
                    fun.accept(s, new Node(s));
                }
            }

            @Override
            public int size() {
                return LazySolrCluster.this.zkStateReader.getClusterState().getLiveNodes().size();
            }
        };
    }

    private SimpleMap<SolrCollection> lazyCollectionsWithAlias(final ZkStateReader zkStateReader) {
        return new SimpleMap<SolrCollection>(){

            @Override
            public SolrCollection get(String key) {
                SolrCollection result = LazySolrCluster.this.collections.get(key);
                if (result != null) {
                    return result;
                }
                Aliases aliases = zkStateReader.getAliases();
                List<String> aliasNames = aliases.resolveAliases(key);
                if (aliasNames == null || aliasNames.isEmpty()) {
                    return null;
                }
                return LazySolrCluster.this._collection(aliasNames.get(0), null);
            }

            @Override
            public void forEachEntry(BiConsumer<String, ? super SolrCollection> fun) {
                LazySolrCluster.this.collections.forEachEntry(fun);
                Aliases aliases = zkStateReader.getAliases();
                aliases.forEachAlias((s, colls) -> {
                    if (colls == null || colls.isEmpty()) {
                        return;
                    }
                    fun.accept((String)s, LazySolrCluster.this._collection((String)colls.get(0), null));
                });
            }

            @Override
            public int size() {
                return LazySolrCluster.this.collections.size() + zkStateReader.getAliases().size();
            }
        };
    }

    private SimpleMap<SolrCollection> lazyCollectionsMap(final ZkStateReader zkStateReader) {
        return new SimpleMap<SolrCollection>(){

            @Override
            public SolrCollection get(String key) {
                return LazySolrCluster.this._collection(key, null);
            }

            @Override
            public void forEachEntry(BiConsumer<String, ? super SolrCollection> fun) {
                zkStateReader.getClusterState().forEachCollection(coll -> fun.accept(coll.getName(), LazySolrCluster.this._collection(coll.getName(), (DocCollection)coll)));
            }

            @Override
            public int size() {
                return zkStateReader.getClusterState().size();
            }
        };
    }

    private SolrCollection _collection(String key, DocCollection c) {
        if (c == null) {
            c = this.zkStateReader.getCollection(key);
        }
        if (c == null) {
            this.cached.remove(key);
            return null;
        }
        SolrCollectionImpl existing = this.cached.get(key);
        if (existing == null || !Objects.equals(existing.coll, c)) {
            existing = new SolrCollectionImpl(c, this.zkStateReader);
            this.cached.put(key, existing);
        }
        return existing;
    }

    @Override
    public SimpleMap<SolrCollection> collections() throws SolrException {
        return this.collections;
    }

    @Override
    public SimpleMap<SolrCollection> collections(boolean includeAlias) throws SolrException {
        return includeAlias ? this.collectionsAndAliases : this.collections;
    }

    @Override
    public SimpleMap<SolrNode> nodes() throws SolrException {
        return this.nodes;
    }

    @Override
    public SimpleMap<CollectionConfig> configs() throws SolrException {
        if (this.configs == null) {
            this.configs = this.lazyConfigMap();
        }
        return this.configs;
    }

    @Override
    public String overseerNode() throws SolrException {
        return null;
    }

    @Override
    public String thisNode() {
        return null;
    }

    private class ConfigImpl
    implements CollectionConfig {
        final String name;
        final SimpleMap<Resource> resources;
        final String path;

        private ConfigImpl(String name) {
            this.name = name;
            this.path = "/configs/" + name;
            this.resources = new SimpleZkMap(LazySolrCluster.this.zkStateReader, this.path);
        }

        @Override
        public SimpleMap<Resource> resources() {
            return this.resources;
        }

        @Override
        public String name() {
            return this.name;
        }
    }

    private class Node
    implements SolrNode {
        private final String name;

        private Node(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String baseUrl(ApiType apiType) {
            return Utils.getBaseUrlForNodeName(this.name, LazySolrCluster.this.zkStateReader.getClusterProperty("urlScheme", "http"), apiType == ApiType.V2);
        }

        @Override
        public SimpleMap<ShardReplica> cores() {
            throw new UnsupportedOperationException("Not yet implemented");
        }
    }

    private class ShardReplicaImpl
    implements ShardReplica {
        private final ShardImpl shard;
        private final Replica replica;

        private ShardReplicaImpl(ShardImpl shard, Replica replica) {
            this.shard = shard;
            this.replica = replica;
        }

        @Override
        public String name() {
            return this.replica.getName();
        }

        @Override
        public String shard() {
            return this.shard.name();
        }

        @Override
        public String collection() {
            return this.shard.collection.name();
        }

        @Override
        public String node() {
            return this.replica.getNodeName();
        }

        @Override
        public String core() {
            return this.replica.getCoreName();
        }

        @Override
        public Replica.Type type() {
            return this.replica.getType();
        }

        @Override
        public boolean alive() {
            return LazySolrCluster.this.zkStateReader.getClusterState().getLiveNodes().contains(this.node()) && this.replica.getState() == Replica.State.ACTIVE;
        }

        @Override
        public long indexSize() {
            throw new UnsupportedOperationException("Not yet implemented");
        }

        @Override
        public boolean isLeader() {
            return Objects.equals(this.shard.leader(), this.name());
        }

        @Override
        public String url(ApiType type) {
            String base = LazySolrCluster.this.nodes.get(this.node()).baseUrl(type);
            if (type == ApiType.V2) {
                return base + "/cores/" + this.core();
            }
            return base + "/" + this.core();
        }
    }

    private class ShardImpl
    implements Shard {
        final SolrCollectionImpl collection;
        final Slice slice;
        final HashRange range;
        final SimpleMap<ShardReplica> replicas;

        private ShardImpl(SolrCollectionImpl collection, Slice slice) {
            this.collection = collection;
            this.slice = slice;
            this.range = this._range(slice);
            this.replicas = this._replicas();
        }

        private SimpleMap<ShardReplica> _replicas() {
            HashMap replicas = new HashMap();
            this.slice.forEach(replica -> replicas.put(replica.getName(), new ShardReplicaImpl(this, (Replica)replica)));
            return new WrappedSimpleMap<ShardReplica>(replicas);
        }

        private HashRange _range(final Slice slice) {
            return slice.getRange() == null ? null : new HashRange(){

                @Override
                public int min() {
                    return slice.getRange().min;
                }

                @Override
                public int max() {
                    return slice.getRange().max;
                }
            };
        }

        @Override
        public String name() {
            return this.slice.getName();
        }

        @Override
        public String collection() {
            return this.collection.name();
        }

        @Override
        public HashRange range() {
            return this.range;
        }

        @Override
        public SimpleMap<ShardReplica> replicas() {
            return this.replicas;
        }

        @Override
        public String leader() {
            Replica leader = this.slice.getLeader();
            return leader == null ? null : leader.getName();
        }
    }

    private class SolrCollectionImpl
    implements SolrCollection {
        final DocCollection coll;
        final SimpleMap<Shard> shards;
        final ZkStateReader zkStateReader;
        final Router router;
        String confName;

        private SolrCollectionImpl(DocCollection coll, ZkStateReader zkStateReader) {
            this.coll = coll;
            this.zkStateReader = zkStateReader;
            this.router = key -> coll.getRouter().getTargetSlice(key, null, null, null, null).getName();
            LinkedHashMap<String, ShardImpl> map = new LinkedHashMap<String, ShardImpl>();
            for (Slice slice : coll.getSlices()) {
                map.put(slice.getName(), new ShardImpl(this, slice));
            }
            this.shards = new WrappedSimpleMap(map);
        }

        @Override
        public String name() {
            return this.coll.getName();
        }

        @Override
        public SimpleMap<Shard> shards() {
            return this.shards;
        }

        @Override
        public String config() {
            if (this.confName == null) {
                try {
                    byte[] d = this.zkStateReader.getZkClient().getData(DocCollection.getCollectionPathRoot(this.coll.getName()), null, null, true);
                    if (d == null || d.length == 0) {
                        return null;
                    }
                    Map m = (Map)Utils.fromJSON(d);
                    this.confName = (String)m.get("configName");
                }
                catch (InterruptedException | KeeperException e) {
                    SimpleZkMap.throwZkExp(e);
                    return null;
                }
            }
            return this.confName;
        }

        @Override
        public Router router() {
            return this.router;
        }
    }
}

