/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.internal;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.semver4j.SemverException;
import org.semver4j.internal.Tokenizers;

public class StrictParser {
    @NotNull
    private static final Pattern pattern = Pattern.compile(Tokenizers.STRICT);
    @NotNull
    private static final BigInteger maxInt = BigInteger.valueOf(Integer.MAX_VALUE);

    @NotNull
    public Version parse(@NotNull String version) {
        Matcher matcher = pattern.matcher(version);
        if (!matcher.matches()) {
            throw new SemverException(String.format(Locale.ROOT, "Version [%s] is not valid semver.", version));
        }
        int major = this.parseInt(matcher.group(1));
        int minor = this.parseInt(matcher.group(2));
        int patch = this.parseInt(matcher.group(3));
        List<String> preRelease = this.convertToList(matcher.group(4));
        List<String> build = this.convertToList(matcher.group(5));
        return new Version(major, minor, patch, preRelease, build);
    }

    private int parseInt(@NotNull String maybeInt) {
        BigInteger secureNumber = new BigInteger(maybeInt);
        if (maxInt.compareTo(secureNumber) < 0) {
            throw new SemverException(String.format(Locale.ROOT, "Value [%s] is too big.", maybeInt));
        }
        return secureNumber.intValue();
    }

    @NotNull
    private @NotNull List<@NotNull String> convertToList(@Nullable String toList) {
        return toList == null ? Collections.emptyList() : Arrays.asList(toList.split("\\."));
    }

    public static class Version {
        private final int major;
        private final int minor;
        private final int patch;
        @NotNull
        private final @NotNull List<@NotNull String> preRelease;
        @NotNull
        private final @NotNull List<@NotNull String> build;

        Version(int major, int minor, int patch, @NotNull @NotNull List<@NotNull String> preRelease, @NotNull @NotNull List<@NotNull String> build) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.preRelease = preRelease;
            this.build = build;
        }

        Version(int major, int minor, int patch) {
            this(major, minor, patch, Collections.emptyList(), Collections.emptyList());
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getPatch() {
            return this.patch;
        }

        @NotNull
        public @NotNull List<@NotNull String> getPreRelease() {
            return this.preRelease;
        }

        @NotNull
        public @NotNull List<@NotNull String> getBuild() {
            return this.build;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Version that = (Version)o;
            return this.major == that.major && Objects.equals(this.minor, that.minor) && Objects.equals(this.patch, that.patch) && Objects.equals(this.preRelease, that.preRelease) && Objects.equals(this.build, that.build);
        }

        public int hashCode() {
            return Objects.hash(this.major, this.minor, this.patch, this.preRelease, this.build);
        }

        @NotNull
        public String toString() {
            return new StringJoiner(", ", Version.class.getSimpleName() + "[", "]").add("major=" + this.major).add("minor=" + this.minor).add("patch=" + this.patch).add("preRelease=" + this.preRelease).add("build=" + this.build).toString();
        }
    }
}

