/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.batch;

import org.apache.camel.CamelContext;
import org.apache.camel.component.spring.batch.SpringBatchComponent;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.launch.JobLauncher;

public class SpringBatchComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    @Override
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        SpringBatchComponent target = (SpringBatchComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                target.setAutowiredEnabled(SpringBatchComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
            case "joblauncher": 
            case "jobLauncher": {
                target.setJobLauncher(SpringBatchComponentConfigurer.property(camelContext, JobLauncher.class, value));
                return true;
            }
            case "jobregistry": 
            case "jobRegistry": {
                target.setJobRegistry(SpringBatchComponentConfigurer.property(camelContext, JobRegistry.class, value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer(SpringBatchComponentConfigurer.property(camelContext, Boolean.TYPE, value));
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> getOptionType(String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return Boolean.TYPE;
            }
            case "joblauncher": 
            case "jobLauncher": {
                return JobLauncher.class;
            }
            case "jobregistry": 
            case "jobRegistry": {
                return JobRegistry.class;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return Boolean.TYPE;
            }
        }
        return null;
    }

    @Override
    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        SpringBatchComponent target = (SpringBatchComponent)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "autowiredenabled": 
            case "autowiredEnabled": {
                return target.isAutowiredEnabled();
            }
            case "joblauncher": 
            case "jobLauncher": {
                return target.getJobLauncher();
            }
            case "jobregistry": 
            case "jobRegistry": {
                return target.getJobRegistry();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
        }
        return null;
    }
}

