/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.JobParametersValidator;
import org.springframework.batch.core.job.flow.Flow;
import org.springframework.batch.core.job.flow.FlowJob;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JobParserJobFactoryBean
implements SmartFactoryBean<FlowJob> {
    private final String name;
    private Boolean restartable;
    private JobRepository jobRepository;
    private JobParametersValidator jobParametersValidator;
    private JobExecutionListener[] jobExecutionListeners;
    private JobParametersIncrementer jobParametersIncrementer;
    private Flow flow;

    public JobParserJobFactoryBean(String name) {
        this.name = name;
    }

    @Override
    public final FlowJob getObject() throws Exception {
        Assert.isTrue(StringUtils.hasText(this.name), "The job must have an id.");
        FlowJob flowJob = new FlowJob(this.name);
        if (this.restartable != null) {
            flowJob.setRestartable(this.restartable);
        }
        if (this.jobRepository != null) {
            flowJob.setJobRepository(this.jobRepository);
        }
        if (this.jobParametersValidator != null) {
            flowJob.setJobParametersValidator(this.jobParametersValidator);
        }
        if (this.jobExecutionListeners != null) {
            flowJob.setJobExecutionListeners(this.jobExecutionListeners);
        }
        if (this.jobParametersIncrementer != null) {
            flowJob.setJobParametersIncrementer(this.jobParametersIncrementer);
        }
        if (this.flow != null) {
            flowJob.setFlow(this.flow);
        }
        flowJob.afterPropertiesSet();
        return flowJob;
    }

    public void setRestartable(Boolean restartable) {
        this.restartable = restartable;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setJobParametersValidator(JobParametersValidator jobParametersValidator) {
        this.jobParametersValidator = jobParametersValidator;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public void setJobExecutionListeners(JobExecutionListener[] jobExecutionListeners) {
        this.jobExecutionListeners = jobExecutionListeners;
    }

    public void setJobParametersIncrementer(JobParametersIncrementer jobParametersIncrementer) {
        this.jobParametersIncrementer = jobParametersIncrementer;
    }

    public void setFlow(Flow flow) {
        this.flow = flow;
    }

    @Override
    public Class<FlowJob> getObjectType() {
        return FlowJob.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public boolean isEagerInit() {
        return true;
    }

    @Override
    public boolean isPrototype() {
        return false;
    }
}

