/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.converter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConversionException;

public class JsonJobParametersConverter
extends DefaultJobParametersConverter {
    private final ObjectMapper objectMapper;

    public JsonJobParametersConverter() {
        this(new ObjectMapper());
    }

    public JsonJobParametersConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    protected String encode(JobParameter<?> jobParameter) {
        Class<?> parameterType = jobParameter.getType();
        Object parameterTypedValue = jobParameter.getValue();
        boolean parameterIdentifying = jobParameter.isIdentifying();
        String parameterStringValue = this.conversionService.convert(parameterTypedValue, String.class);
        try {
            return this.objectMapper.writeValueAsString((Object)new JobParameterDefinition(parameterStringValue, parameterType.getName(), Boolean.toString(parameterIdentifying)));
        }
        catch (JsonProcessingException e) {
            throw new JobParametersConversionException("Unable to encode job parameter " + jobParameter, e);
        }
    }

    protected JobParameter decode(String encodedJobParameter) {
        try {
            JobParameterDefinition jobParameterDefinition = (JobParameterDefinition)this.objectMapper.readValue(encodedJobParameter, JobParameterDefinition.class);
            Class parameterType = String.class;
            if (jobParameterDefinition.type() != null) {
                parameterType = Class.forName(jobParameterDefinition.type());
            }
            boolean parameterIdentifying = true;
            if (jobParameterDefinition.identifying() != null && !jobParameterDefinition.identifying().isEmpty()) {
                parameterIdentifying = Boolean.parseBoolean(jobParameterDefinition.identifying());
            }
            String parameterTypedValue = this.conversionService.convert((Object)jobParameterDefinition.value(), parameterType);
            return new JobParameter<String>(parameterTypedValue, parameterType, parameterIdentifying);
        }
        catch (JsonProcessingException | ClassNotFoundException e) {
            throw new JobParametersConversionException("Unable to decode job parameter " + encodedJobParameter, e);
        }
    }

    public record JobParameterDefinition(String value, String type, String identifying) {
    }
}

