/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.builder;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.observation.ObservationRegistry;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.batch.core.annotation.AfterStep;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.listener.StepListenerFactoryBean;
import org.springframework.batch.core.observability.BatchStepObservationConvention;
import org.springframework.batch.core.observability.DefaultBatchStepObservationConvention;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.AbstractStep;
import org.springframework.batch.support.ReflectionUtils;

public abstract class StepBuilderHelper<B extends StepBuilderHelper<B>> {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final CommonStepProperties properties;

    @Deprecated(since="5.1", forRemoval=true)
    public StepBuilderHelper(String name) {
        this.properties = new CommonStepProperties();
        this.properties.name = name;
    }

    public StepBuilderHelper(String name, JobRepository jobRepository) {
        this.properties = new CommonStepProperties();
        this.properties.name = name;
        this.properties.jobRepository = jobRepository;
    }

    protected StepBuilderHelper(StepBuilderHelper<?> parent) {
        this.properties = new CommonStepProperties(parent.properties);
    }

    @Deprecated(since="5.1", forRemoval=true)
    public B repository(JobRepository jobRepository) {
        this.properties.jobRepository = jobRepository;
        return this.self();
    }

    public B observationConvention(BatchStepObservationConvention observationConvention) {
        this.properties.observationConvention = observationConvention;
        return this.self();
    }

    public B observationRegistry(ObservationRegistry observationRegistry) {
        this.properties.observationRegistry = observationRegistry;
        return this.self();
    }

    public B meterRegistry(MeterRegistry meterRegistry) {
        this.properties.meterRegistry = meterRegistry;
        return this.self();
    }

    public B startLimit(int startLimit) {
        this.properties.startLimit = startLimit;
        return this.self();
    }

    public B listener(Object listener) {
        HashSet<Method> stepExecutionListenerMethods = new HashSet<Method>();
        stepExecutionListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), BeforeStep.class));
        stepExecutionListenerMethods.addAll(ReflectionUtils.findMethod(listener.getClass(), AfterStep.class));
        if (stepExecutionListenerMethods.size() > 0) {
            StepListenerFactoryBean factory = new StepListenerFactoryBean();
            factory.setDelegate(listener);
            this.properties.addStepExecutionListener((StepExecutionListener)factory.getObject());
        }
        return this.self();
    }

    public B listener(StepExecutionListener listener) {
        this.properties.addStepExecutionListener(listener);
        return this.self();
    }

    public B allowStartIfComplete(boolean allowStartIfComplete) {
        this.properties.allowStartIfComplete = allowStartIfComplete;
        return this.self();
    }

    protected abstract B self();

    protected String getName() {
        return this.properties.name;
    }

    protected JobRepository getJobRepository() {
        return this.properties.jobRepository;
    }

    protected boolean isAllowStartIfComplete() {
        return this.properties.allowStartIfComplete != null ? this.properties.allowStartIfComplete : false;
    }

    protected void enhance(AbstractStep step) {
        Boolean allowStartIfComplete;
        MeterRegistry meterRegistry;
        ObservationRegistry observationRegistry;
        step.setJobRepository(this.properties.getJobRepository());
        BatchStepObservationConvention observationConvention = this.properties.getObservationConvention();
        if (observationConvention != null) {
            step.setObservationConvention(observationConvention);
        }
        if ((observationRegistry = this.properties.getObservationRegistry()) != null) {
            step.setObservationRegistry(observationRegistry);
        }
        if ((meterRegistry = this.properties.getMeterRegistry()) != null) {
            step.setMeterRegistry(meterRegistry);
        }
        if ((allowStartIfComplete = this.properties.allowStartIfComplete) != null) {
            step.setAllowStartIfComplete(allowStartIfComplete);
        }
        step.setStartLimit(this.properties.startLimit);
        List<StepExecutionListener> listeners = this.properties.stepExecutionListeners;
        if (!listeners.isEmpty()) {
            step.setStepExecutionListeners(listeners.toArray(new StepExecutionListener[0]));
        }
    }

    public static class CommonStepProperties {
        private List<StepExecutionListener> stepExecutionListeners = new ArrayList<StepExecutionListener>();
        private int startLimit = Integer.MAX_VALUE;
        private Boolean allowStartIfComplete;
        private JobRepository jobRepository;
        private BatchStepObservationConvention observationConvention = new DefaultBatchStepObservationConvention();
        private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
        private MeterRegistry meterRegistry = Metrics.globalRegistry;
        private String name;

        public CommonStepProperties() {
        }

        public CommonStepProperties(CommonStepProperties properties) {
            this.name = properties.name;
            this.startLimit = properties.startLimit;
            this.allowStartIfComplete = properties.allowStartIfComplete;
            this.jobRepository = properties.jobRepository;
            this.observationConvention = properties.observationConvention;
            this.observationRegistry = properties.observationRegistry;
            this.meterRegistry = properties.meterRegistry;
            this.stepExecutionListeners = new ArrayList<StepExecutionListener>(properties.stepExecutionListeners);
        }

        public JobRepository getJobRepository() {
            return this.jobRepository;
        }

        public void setJobRepository(JobRepository jobRepository) {
            this.jobRepository = jobRepository;
        }

        public BatchStepObservationConvention getObservationConvention() {
            return this.observationConvention;
        }

        public void setObservationConvention(BatchStepObservationConvention observationConvention) {
            this.observationConvention = observationConvention;
        }

        public ObservationRegistry getObservationRegistry() {
            return this.observationRegistry;
        }

        public void setObservationRegistry(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
        }

        public MeterRegistry getMeterRegistry() {
            return this.meterRegistry;
        }

        public void setMeterRegistry(MeterRegistry meterRegistry) {
            this.meterRegistry = meterRegistry;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<StepExecutionListener> getStepExecutionListeners() {
            return this.stepExecutionListeners;
        }

        public void addStepExecutionListeners(List<StepExecutionListener> stepExecutionListeners) {
            this.stepExecutionListeners.addAll(stepExecutionListeners);
        }

        public void addStepExecutionListener(StepExecutionListener stepExecutionListener) {
            this.stepExecutionListeners.add(stepExecutionListener);
        }

        public Integer getStartLimit() {
            return this.startLimit;
        }

        public void setStartLimit(Integer startLimit) {
            this.startLimit = startLimit;
        }

        public Boolean getAllowStartIfComplete() {
            return this.allowStartIfComplete;
        }

        public void setAllowStartIfComplete(Boolean allowStartIfComplete) {
            this.allowStartIfComplete = allowStartIfComplete;
        }
    }
}

