/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.core.listener.ItemListenerSupport;
import org.springframework.batch.item.Chunk;

public class DefaultItemFailureHandler
extends ItemListenerSupport<Object, Object> {
    protected static final Log logger = LogFactory.getLog(DefaultItemFailureHandler.class);

    @Override
    public void onReadError(Exception ex) {
        try {
            logger.error("Error encountered while reading", ex);
        }
        catch (Exception exception) {
            logger.error("Invalid type for logging: [" + exception + "]");
        }
    }

    @Override
    public void onWriteError(Exception ex, Chunk<?> item) {
        try {
            logger.error("Error encountered while writing item: [ " + item + "]", ex);
        }
        catch (Exception exception) {
            logger.error("Invalid type for logging: [" + exception + "]");
        }
    }
}

