/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.job;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.step.job.JobParametersExtractor;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class DefaultJobParametersExtractor
implements JobParametersExtractor {
    private Set<String> keys = new HashSet<String>();
    private boolean useAllParentParameters = true;
    private JobParametersConverter jobParametersConverter = new DefaultJobParametersConverter();

    public void setKeys(String[] keys) {
        this.keys = new HashSet<String>(Arrays.asList(keys));
    }

    @Override
    public JobParameters getJobParameters(Job job, StepExecution stepExecution) {
        JobParametersBuilder builder = new JobParametersBuilder();
        Map<String, JobParameter<?>> jobParameters = stepExecution.getJobParameters().getParameters();
        ExecutionContext executionContext = stepExecution.getExecutionContext();
        if (this.useAllParentParameters) {
            for (String key : jobParameters.keySet()) {
                builder.addJobParameter(key, jobParameters.get(key));
            }
        }
        Properties properties = new Properties();
        for (String key : this.keys) {
            if (executionContext.containsKey(key)) {
                properties.setProperty(key, executionContext.getString(key));
                continue;
            }
            if (!jobParameters.containsKey(key)) continue;
            builder.addJobParameter(key, jobParameters.get(key));
        }
        builder.addJobParameters(this.jobParametersConverter.getJobParameters(properties));
        return builder.toJobParameters();
    }

    public void setUseAllParentParameters(boolean useAllParentParameters) {
        this.useAllParentParameters = useAllParentParameters;
    }

    public void setJobParametersConverter(@NonNull JobParametersConverter jobParametersConverter) {
        Assert.notNull((Object)jobParametersConverter, "jobParametersConverter must not be null");
        this.jobParametersConverter = jobParametersConverter;
    }
}

