/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item;

import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.converter.Converter;
import org.springframework.util.Assert;

public abstract class KeyValueItemWriter<K, V>
implements ItemWriter<V>,
InitializingBean {
    protected Converter<V, K> itemKeyMapper;
    protected boolean delete;

    @Override
    public void write(Chunk<? extends V> items) throws Exception {
        if (items == null) {
            return;
        }
        for (Object item : items) {
            K key = this.itemKeyMapper.convert(item);
            this.writeKeyValue(key, item);
        }
        this.flush();
    }

    protected void flush() throws Exception {
    }

    protected abstract void writeKeyValue(K var1, V var2);

    protected abstract void init();

    public void setItemKeyMapper(Converter<V, K> itemKeyMapper) {
        this.itemKeyMapper = itemKeyMapper;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.itemKeyMapper != null, "itemKeyMapper requires a Converter type.");
        this.init();
    }
}

