/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.adapter;

import java.util.Arrays;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.adapter.AbstractMethodInvokingDelegator;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class PropertyExtractingDelegatingItemWriter<T>
extends AbstractMethodInvokingDelegator<T>
implements ItemWriter<T> {
    private String[] fieldsUsedAsTargetMethodArguments;

    @Override
    public void write(Chunk<? extends T> items) throws Exception {
        for (Object item : items) {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(item);
            Object[] methodArguments = new Object[this.fieldsUsedAsTargetMethodArguments.length];
            for (int i = 0; i < this.fieldsUsedAsTargetMethodArguments.length; ++i) {
                methodArguments[i] = beanWrapper.getPropertyValue(this.fieldsUsedAsTargetMethodArguments[i]);
            }
            this.invokeDelegateMethodWithArguments(methodArguments);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.state(!ObjectUtils.isEmpty(this.fieldsUsedAsTargetMethodArguments), "fieldsUsedAsTargetMethodArguments must not be empty");
    }

    public void setFieldsUsedAsTargetMethodArguments(String[] fieldsUsedAsMethodArguments) {
        this.fieldsUsedAsTargetMethodArguments = Arrays.asList(fieldsUsedAsMethodArguments).toArray(new String[fieldsUsedAsMethodArguments.length]);
    }
}

