/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import org.bson.Document;
import org.bson.types.ObjectId;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MongoItemWriter<T>
implements ItemWriter<T>,
InitializingBean {
    private static final String ID_KEY = "_id";
    private MongoOperations template;
    private final Object bufferKey;
    private String collection;
    private Mode mode = Mode.UPSERT;

    public MongoItemWriter() {
        this.bufferKey = new Object();
    }

    @Deprecated(since="5.1", forRemoval=true)
    public void setDelete(boolean delete) {
        this.mode = delete ? Mode.REMOVE : Mode.UPSERT;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setTemplate(MongoOperations template) {
        this.template = template;
    }

    protected MongoOperations getTemplate() {
        return this.template;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public String getCollection() {
        return this.collection;
    }

    @Override
    public void write(Chunk<? extends T> chunk) throws Exception {
        if (!this.transactionActive()) {
            this.doWrite(chunk);
            return;
        }
        Chunk<T> bufferedItems = this.getCurrentBuffer();
        bufferedItems.addAll(chunk.getItems());
    }

    protected void doWrite(Chunk<? extends T> chunk) {
        if (!CollectionUtils.isEmpty(chunk.getItems())) {
            switch (this.mode) {
                case INSERT: {
                    this.insert(chunk);
                    break;
                }
                case REMOVE: {
                    this.remove(chunk);
                    break;
                }
                default: {
                    this.upsert(chunk);
                }
            }
        }
    }

    private void insert(Chunk<? extends T> chunk) {
        BulkOperations bulkOperations = this.initBulkOperations(BulkOperations.BulkMode.ORDERED, chunk.getItems().get(0));
        MongoConverter mongoConverter = this.template.getConverter();
        for (Object item : chunk) {
            Document document = new Document();
            mongoConverter.write(item, (Object)document);
            bulkOperations.insert((Object)document);
        }
        bulkOperations.execute();
    }

    private void remove(Chunk<? extends T> chunk) {
        BulkOperations bulkOperations = this.initBulkOperations(BulkOperations.BulkMode.ORDERED, chunk.getItems().get(0));
        MongoConverter mongoConverter = this.template.getConverter();
        for (Object item : chunk) {
            Document document = new Document();
            mongoConverter.write(item, (Object)document);
            Object objectId = document.get((Object)ID_KEY);
            if (objectId == null) continue;
            Query query2 = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)ID_KEY).is(objectId));
            bulkOperations.remove(query2);
        }
        bulkOperations.execute();
    }

    private void upsert(Chunk<? extends T> chunk) {
        BulkOperations bulkOperations = this.initBulkOperations(BulkOperations.BulkMode.ORDERED, chunk.getItems().get(0));
        MongoConverter mongoConverter = this.template.getConverter();
        FindAndReplaceOptions upsert = new FindAndReplaceOptions().upsert();
        for (Object item : chunk) {
            Document document = new Document();
            mongoConverter.write(item, (Object)document);
            Object objectId = document.get((Object)ID_KEY) != null ? document.get((Object)ID_KEY) : new ObjectId();
            Query query2 = new Query().addCriteria((CriteriaDefinition)Criteria.where((String)ID_KEY).is(objectId));
            bulkOperations.replaceOne(query2, (Object)document, upsert);
        }
        bulkOperations.execute();
    }

    private BulkOperations initBulkOperations(BulkOperations.BulkMode bulkMode, Object item) {
        BulkOperations bulkOperations = StringUtils.hasText(this.collection) ? this.template.bulkOps(bulkMode, this.collection) : this.template.bulkOps(bulkMode, ClassUtils.getUserClass(item));
        return bulkOperations;
    }

    private boolean transactionActive() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    @Nullable
    private Chunk<T> getCurrentBuffer() {
        if (!TransactionSynchronizationManager.hasResource(this.bufferKey)) {
            TransactionSynchronizationManager.bindResource(this.bufferKey, new Chunk<Object>(new Object[0]));
            TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization(){

                @Override
                public void beforeCommit(boolean readOnly) {
                    Chunk chunk = (Chunk)TransactionSynchronizationManager.getResource(MongoItemWriter.this.bufferKey);
                    if (!CollectionUtils.isEmpty(chunk.getItems()) && !readOnly) {
                        MongoItemWriter.this.doWrite(chunk);
                    }
                }

                @Override
                public void afterCompletion(int status) {
                    if (TransactionSynchronizationManager.hasResource(MongoItemWriter.this.bufferKey)) {
                        TransactionSynchronizationManager.unbindResource(MongoItemWriter.this.bufferKey);
                    }
                }
            });
        }
        return (Chunk)TransactionSynchronizationManager.getResource(this.bufferKey);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.template != null, "A MongoOperations implementation is required.");
    }

    public static enum Mode {
        INSERT,
        UPSERT,
        REMOVE;

    }
}

