/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public abstract class AbstractPagingItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements InitializingBean {
    protected Log logger = LogFactory.getLog(this.getClass());
    private volatile boolean initialized = false;
    private int pageSize = 10;
    private volatile int current = 0;
    private volatile int page = 0;
    protected volatile List<T> results;
    private final Lock lock = new ReentrantLock();

    public AbstractPagingItemReader() {
        this.setName(ClassUtils.getShortName(AbstractPagingItemReader.class));
    }

    public int getPage() {
        return this.page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.pageSize > 0, "pageSize must be greater than zero");
    }

    @Override
    @Nullable
    protected T doRead() throws Exception {
        this.lock.lock();
        try {
            int next;
            if (this.results == null || this.current >= this.pageSize) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Reading page " + this.getPage());
                }
                this.doReadPage();
                ++this.page;
                if (this.current >= this.pageSize) {
                    this.current = 0;
                }
            }
            if ((next = this.current++) < this.results.size()) {
                T t = this.results.get(next);
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract void doReadPage();

    @Override
    protected void doOpen() throws Exception {
        Assert.state(!this.initialized, "Cannot open an already opened ItemReader, call close first");
        this.initialized = true;
    }

    @Override
    protected void doClose() throws Exception {
        this.lock.lock();
        try {
            this.initialized = false;
            this.current = 0;
            this.page = 0;
            this.results = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    protected void jumpToItem(int itemIndex) throws Exception {
        this.lock.lock();
        try {
            this.page = itemIndex / this.pageSize;
            this.current = itemIndex % this.pageSize;
        }
        finally {
            this.lock.unlock();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Jumping to page " + this.getPage() + " and index " + this.current);
        }
    }
}

