/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.springframework.batch.item.ParseException;
import org.springframework.batch.item.json.JsonObjectReader;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JacksonJsonObjectReader<T>
implements JsonObjectReader<T> {
    private final Class<? extends T> itemType;
    private JsonParser jsonParser;
    private ObjectMapper mapper;
    private InputStream inputStream;

    public JacksonJsonObjectReader(Class<? extends T> itemType) {
        this(new ObjectMapper(), itemType);
    }

    public JacksonJsonObjectReader(ObjectMapper mapper, Class<? extends T> itemType) {
        this.mapper = mapper;
        this.itemType = itemType;
    }

    public void setMapper(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, "The mapper must not be null");
        this.mapper = mapper;
    }

    @Override
    public void open(Resource resource) throws Exception {
        Assert.notNull((Object)resource, "The resource must not be null");
        this.inputStream = resource.getInputStream();
        this.jsonParser = this.mapper.getFactory().createParser(this.inputStream);
        Assert.state(this.jsonParser.nextToken() == JsonToken.START_ARRAY, "The Json input stream must start with an array of Json objects");
    }

    @Override
    @Nullable
    public T read() throws Exception {
        try {
            if (this.jsonParser.nextToken() == JsonToken.START_OBJECT) {
                return (T)this.mapper.readValue(this.jsonParser, this.itemType);
            }
        }
        catch (IOException e) {
            throw new ParseException("Unable to read next JSON object", e);
        }
        return null;
    }

    @Override
    public void close() throws Exception {
        this.inputStream.close();
        this.jsonParser.close();
    }
}

