/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.redis;

import org.springframework.batch.item.KeyValueItemWriter;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public class RedisItemWriter<K, T>
extends KeyValueItemWriter<K, T> {
    private RedisTemplate<K, T> redisTemplate;

    @Override
    protected void writeKeyValue(K key, T value) {
        if (this.delete) {
            this.redisTemplate.delete(key);
        } else {
            this.redisTemplate.opsForValue().set(key, value);
        }
    }

    @Override
    protected void init() {
        Assert.notNull(this.redisTemplate, "RedisTemplate must not be null");
    }

    public void setRedisTemplate(RedisTemplate<K, T> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }
}

