/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.batch;

import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.spring.batch.SpringBatchEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.launch.JobLauncher;

@Component(value="spring-batch")
public class SpringBatchComponent
extends DefaultComponent {
    private static final String DEFAULT_JOB_LAUNCHER_REF_NAME = "jobLauncher";
    private JobLauncher defaultResolvedJobLauncher;
    private Map<String, JobLauncher> allResolvedJobLaunchers;
    @Metadata
    private JobLauncher jobLauncher;
    @Metadata
    private JobRegistry jobRegistry;

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SpringBatchEndpoint endpoint = new SpringBatchEndpoint(uri, this, this.jobLauncher, this.defaultResolvedJobLauncher, this.allResolvedJobLaunchers, remaining, this.jobRegistry);
        this.setProperties(endpoint, parameters);
        return endpoint;
    }

    @Override
    protected void doInit() throws Exception {
        super.doInit();
        this.defaultResolvedJobLauncher = this.getCamelContext().getRegistry().lookupByNameAndType(DEFAULT_JOB_LAUNCHER_REF_NAME, JobLauncher.class);
        this.allResolvedJobLaunchers = this.getCamelContext().getRegistry().findByTypeWithName(JobLauncher.class);
    }

    public JobLauncher getJobLauncher() {
        return this.jobLauncher;
    }

    public void setJobLauncher(JobLauncher jobLauncher) {
        this.jobLauncher = jobLauncher;
    }

    public JobRegistry getJobRegistry() {
        return this.jobRegistry;
    }

    public void setJobRegistry(JobRegistry jobRegistry) {
        this.jobRegistry = jobRegistry;
    }
}

