/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.batch.support;

import org.apache.camel.ConsumerTemplate;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemReader;
import org.springframework.beans.factory.InitializingBean;

public class CamelItemReader<I>
extends ServiceSupport
implements ItemReader<I>,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(CamelItemReader.class);
    private final ConsumerTemplate consumerTemplate;
    private final String endpointUri;

    public CamelItemReader(ConsumerTemplate consumerTemplate, String endpointUri) {
        this.consumerTemplate = consumerTemplate;
        this.endpointUri = endpointUri;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        ObjectHelper.notNull(this.consumerTemplate.getCamelContext(), "CamelContext", this);
        this.consumerTemplate.getCamelContext().addService(this);
    }

    @Override
    public I read() throws Exception {
        LOG.debug("reading new item...");
        Object item = this.consumerTemplate.receiveBody(this.endpointUri);
        LOG.debug("read item [{}]", item);
        return (I)item;
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.consumerTemplate);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.consumerTemplate);
    }

    public ConsumerTemplate getConsumerTemplate() {
        return this.consumerTemplate;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }
}

