/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.List;
import org.springframework.batch.core.configuration.xml.ChunkElementParser;
import org.springframework.batch.core.configuration.xml.StepListenerParser;
import org.springframework.batch.core.configuration.xml.StepParserStepFactoryBean;
import org.springframework.batch.core.step.tasklet.MethodInvokingTaskletAdapter;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class TaskletParser {
    private static final String TRANSACTION_MANAGER_ATTR = "transaction-manager";
    private static final String TASKLET_REF_ATTR = "ref";
    private static final String TASKLET_METHOD_ATTR = "method";
    private static final String BEAN_ELE = "bean";
    private static final String REF_ELE = "ref";
    private static final String TASK_EXECUTOR_ATTR = "task-executor";
    private static final String CHUNK_ELE = "chunk";
    private static final String TX_ATTRIBUTES_ELE = "transaction-attributes";
    private static final String MERGE_ATTR = "merge";
    private static final ChunkElementParser chunkElementParser = new ChunkElementParser();
    private static final StepListenerParser stepListenerParser = new StepListenerParser();

    public void parseTasklet(Element stepElement, Element taskletElement, AbstractBeanDefinition bd, ParserContext parserContext, boolean stepUnderspecified) {
        bd.setBeanClass(StepParserStepFactoryBean.class);
        bd.setAttribute("isNamespaceStep", true);
        String taskletRef = taskletElement.getAttribute("ref");
        String taskletMethod = taskletElement.getAttribute(TASKLET_METHOD_ATTR);
        List<Element> chunkElements = DomUtils.getChildElementsByTagName(taskletElement, CHUNK_ELE);
        List<Element> beanElements = DomUtils.getChildElementsByTagName(taskletElement, BEAN_ELE);
        List<Element> refElements = DomUtils.getChildElementsByTagName(taskletElement, "ref");
        this.validateTaskletAttributesAndSubelements(taskletElement, parserContext, stepUnderspecified, taskletRef, chunkElements, beanElements, refElements);
        if (!chunkElements.isEmpty()) {
            chunkElementParser.parse(chunkElements.get(0), bd, parserContext, stepUnderspecified);
        } else {
            BeanMetadataElement bme = null;
            if (StringUtils.hasText(taskletRef)) {
                bme = new RuntimeBeanReference(taskletRef);
            } else if (beanElements.size() == 1) {
                Element beanElement = beanElements.get(0);
                BeanDefinitionHolder beanDefinitionHolder = parserContext.getDelegate().parseBeanDefinitionElement(beanElement, bd);
                parserContext.getDelegate().decorateBeanDefinitionIfRequired(beanElement, beanDefinitionHolder);
                bme = beanDefinitionHolder;
            } else if (refElements.size() == 1) {
                bme = (BeanMetadataElement)parserContext.getDelegate().parsePropertySubElement(refElements.get(0), null);
            }
            if (StringUtils.hasText(taskletMethod)) {
                bme = this.getTaskletAdapter(bme, taskletMethod);
            }
            if (bme != null) {
                bd.getPropertyValues().addPropertyValue("tasklet", bme);
            }
        }
        this.handleTaskletElement(taskletElement, bd, parserContext);
    }

    private BeanMetadataElement getTaskletAdapter(BeanMetadataElement bme, String taskletMethod) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MethodInvokingTaskletAdapter.class);
        builder.addPropertyValue("targetMethod", taskletMethod);
        builder.addPropertyValue("targetObject", bme);
        return builder.getBeanDefinition();
    }

    private void validateTaskletAttributesAndSubelements(Element taskletElement, ParserContext parserContext, boolean stepUnderspecified, String taskletRef, List<Element> chunkElements, List<Element> beanElements, List<Element> refElements) {
        int total = (StringUtils.hasText(taskletRef) ? 1 : 0) + chunkElements.size() + beanElements.size() + refElements.size();
        StringBuilder found = new StringBuilder();
        if (total > 1) {
            if (StringUtils.hasText(taskletRef)) {
                found.append("'ref' attribute, ");
            }
            if (chunkElements.size() == 1) {
                found.append("<chunk/> element, ");
            } else if (chunkElements.size() > 1) {
                found.append(chunkElements.size()).append(" <").append(CHUNK_ELE).append("/> elements, ");
            }
            if (beanElements.size() == 1) {
                found.append("<bean/> element, ");
            } else if (beanElements.size() > 1) {
                found.append(beanElements.size()).append(" <").append(BEAN_ELE).append("/> elements, ");
            }
            if (refElements.size() == 1) {
                found.append("<ref/> element, ");
            } else if (refElements.size() > 1) {
                found.append(refElements.size()).append(" <").append("ref").append("/> elements, ");
            }
            found.delete(found.length() - 2, found.length());
        } else {
            found.append("None");
        }
        String error = null;
        if (stepUnderspecified) {
            if (total > 1) {
                error = "may not have more than";
            }
        } else if (total != 1) {
            error = "must have exactly";
        }
        if (error != null) {
            parserContext.getReaderContext().error("The <" + taskletElement.getTagName() + "/> element " + error + " one of: 'ref' attribute, <chunk/> element, <bean/> attribute, or <ref/> element.  Found: " + found + ".", taskletElement);
        }
    }

    private void handleTaskletElement(Element taskletElement, AbstractBeanDefinition bd, ParserContext parserContext) {
        MutablePropertyValues propertyValues = bd.getPropertyValues();
        this.handleTaskletAttributes(taskletElement, propertyValues);
        this.handleTransactionAttributesElement(taskletElement, propertyValues);
        stepListenerParser.handleListenersElement(taskletElement, bd, parserContext);
        this.handleExceptionElement(taskletElement, parserContext, propertyValues, "no-rollback-exception-classes", "noRollbackExceptionClasses");
        bd.setRole(1);
        bd.setSource(parserContext.extractSource(taskletElement));
    }

    private void handleTransactionAttributesElement(Element stepElement, MutablePropertyValues propertyValues) {
        List<Element> txAttrElements = DomUtils.getChildElementsByTagName(stepElement, TX_ATTRIBUTES_ELE);
        if (txAttrElements.size() == 1) {
            String timeout;
            String isolation;
            Element txAttrElement = txAttrElements.get(0);
            String propagation = txAttrElement.getAttribute("propagation");
            if (StringUtils.hasText(propagation)) {
                propertyValues.addPropertyValue("propagation", propagation);
            }
            if (StringUtils.hasText(isolation = txAttrElement.getAttribute("isolation"))) {
                propertyValues.addPropertyValue("isolation", isolation);
            }
            if (StringUtils.hasText(timeout = txAttrElement.getAttribute("timeout"))) {
                propertyValues.addPropertyValue("transactionTimeout", timeout);
            }
        }
    }

    private void handleExceptionElement(Element element, ParserContext parserContext, MutablePropertyValues propertyValues, String exceptionListName, String propertyName) {
        List<Element> children = DomUtils.getChildElementsByTagName(element, exceptionListName);
        if (children.size() == 1) {
            Element exceptionClassesElement = children.get(0);
            ManagedList<TypedStringValue> list = new ManagedList<TypedStringValue>();
            list.setMergeEnabled(exceptionClassesElement.hasAttribute(MERGE_ATTR) && Boolean.parseBoolean(exceptionClassesElement.getAttribute(MERGE_ATTR)));
            this.addExceptionClasses("include", exceptionClassesElement, list, parserContext);
            propertyValues.addPropertyValue(propertyName, list);
        } else if (children.size() > 1) {
            parserContext.getReaderContext().error("The <" + exceptionListName + "/> element may not appear more than once in a single <" + element.getNodeName() + "/>.", element);
        }
    }

    private void addExceptionClasses(String elementName, Element exceptionClassesElement, ManagedList<TypedStringValue> list, ParserContext parserContext) {
        for (Element child : DomUtils.getChildElementsByTagName(exceptionClassesElement, elementName)) {
            String className = child.getAttribute("class");
            list.add(new TypedStringValue(className, Class.class));
        }
    }

    private void handleTaskletAttributes(Element taskletElement, MutablePropertyValues propertyValues) {
        String throttleLimit;
        String taskExecutorBeanId;
        String allowStartIfComplete;
        String startLimit;
        String transactionManagerRef = taskletElement.getAttribute(TRANSACTION_MANAGER_ATTR);
        if (StringUtils.hasText(transactionManagerRef)) {
            propertyValues.addPropertyValue("transactionManager", new RuntimeBeanReference(transactionManagerRef));
        }
        if (StringUtils.hasText(startLimit = taskletElement.getAttribute("start-limit"))) {
            propertyValues.addPropertyValue("startLimit", startLimit);
        }
        if (StringUtils.hasText(allowStartIfComplete = taskletElement.getAttribute("allow-start-if-complete"))) {
            propertyValues.addPropertyValue("allowStartIfComplete", allowStartIfComplete);
        }
        if (StringUtils.hasText(taskExecutorBeanId = taskletElement.getAttribute(TASK_EXECUTOR_ATTR))) {
            RuntimeBeanReference taskExecutorRef = new RuntimeBeanReference(taskExecutorBeanId);
            propertyValues.addPropertyValue("taskExecutor", taskExecutorRef);
        }
        if (StringUtils.hasText(throttleLimit = taskletElement.getAttribute("throttle-limit"))) {
            propertyValues.addPropertyValue("throttleLimit", throttleLimit);
        }
    }
}

