/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.explore.support;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.sql.DataSource;
import org.springframework.batch.core.DefaultJobKeyGenerator;
import org.springframework.batch.core.JobKeyGenerator;
import org.springframework.batch.core.converter.DateToStringConverter;
import org.springframework.batch.core.converter.LocalDateTimeToStringConverter;
import org.springframework.batch.core.converter.LocalDateToStringConverter;
import org.springframework.batch.core.converter.LocalTimeToStringConverter;
import org.springframework.batch.core.converter.StringToDateConverter;
import org.springframework.batch.core.converter.StringToLocalDateConverter;
import org.springframework.batch.core.converter.StringToLocalDateTimeConverter;
import org.springframework.batch.core.converter.StringToLocalTimeConverter;
import org.springframework.batch.core.explore.support.AbstractJobExplorerFactoryBean;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.batch.core.repository.dao.DefaultExecutionContextSerializer;
import org.springframework.batch.core.repository.dao.ExecutionContextDao;
import org.springframework.batch.core.repository.dao.JdbcExecutionContextDao;
import org.springframework.batch.core.repository.dao.JdbcJobExecutionDao;
import org.springframework.batch.core.repository.dao.JdbcJobInstanceDao;
import org.springframework.batch.core.repository.dao.JdbcStepExecutionDao;
import org.springframework.batch.core.repository.dao.JobExecutionDao;
import org.springframework.batch.core.repository.dao.JobInstanceDao;
import org.springframework.batch.core.repository.dao.StepExecutionDao;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.incrementer.AbstractDataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.incrementer.DataFieldMaxValueIncrementer;
import org.springframework.jdbc.support.lob.LobHandler;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;

public class JobExplorerFactoryBean
extends AbstractJobExplorerFactoryBean
implements InitializingBean {
    private DataSource dataSource;
    private JdbcOperations jdbcOperations;
    private String tablePrefix = "BATCH_";
    private final DataFieldMaxValueIncrementer incrementer = new AbstractDataFieldMaxValueIncrementer(){

        @Override
        protected long getNextKey() {
            throw new IllegalStateException("JobExplorer is read only.");
        }
    };
    private JobKeyGenerator jobKeyGenerator;
    private LobHandler lobHandler;
    private ExecutionContextSerializer serializer;
    private Charset charset = StandardCharsets.UTF_8;
    private ConfigurableConversionService conversionService;

    public void setSerializer(ExecutionContextSerializer serializer) {
        this.serializer = serializer;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setJdbcOperations(JdbcOperations jdbcOperations) {
        this.jdbcOperations = jdbcOperations;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public void setJobKeyGenerator(JobKeyGenerator jobKeyGenerator) {
        this.jobKeyGenerator = jobKeyGenerator;
    }

    public void setLobHandler(LobHandler lobHandler) {
        this.lobHandler = lobHandler;
    }

    public void setCharset(@NonNull Charset charset) {
        Assert.notNull((Object)charset, "Charset must not be null");
        this.charset = charset;
    }

    public void setConversionService(@NonNull ConfigurableConversionService conversionService) {
        Assert.notNull((Object)conversionService, "ConversionService must not be null");
        this.conversionService = conversionService;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.dataSource != null, "DataSource must not be null.");
        if (this.jdbcOperations == null) {
            this.jdbcOperations = new JdbcTemplate(this.dataSource);
        }
        if (this.jobKeyGenerator == null) {
            this.jobKeyGenerator = new DefaultJobKeyGenerator();
        }
        if (this.serializer == null) {
            this.serializer = new DefaultExecutionContextSerializer();
        }
        if (this.conversionService == null) {
            DefaultConversionService conversionService = new DefaultConversionService();
            conversionService.addConverter(new DateToStringConverter());
            conversionService.addConverter(new StringToDateConverter());
            conversionService.addConverter(new LocalDateToStringConverter());
            conversionService.addConverter(new StringToLocalDateConverter());
            conversionService.addConverter(new LocalTimeToStringConverter());
            conversionService.addConverter(new StringToLocalTimeConverter());
            conversionService.addConverter(new LocalDateTimeToStringConverter());
            conversionService.addConverter(new StringToLocalDateTimeConverter());
            this.conversionService = conversionService;
        }
        super.afterPropertiesSet();
    }

    @Override
    protected ExecutionContextDao createExecutionContextDao() throws Exception {
        JdbcExecutionContextDao dao = new JdbcExecutionContextDao();
        dao.setJdbcTemplate(this.jdbcOperations);
        dao.setLobHandler(this.lobHandler);
        dao.setTablePrefix(this.tablePrefix);
        dao.setSerializer(this.serializer);
        dao.setCharset(this.charset);
        dao.afterPropertiesSet();
        return dao;
    }

    @Override
    protected JobInstanceDao createJobInstanceDao() throws Exception {
        JdbcJobInstanceDao dao = new JdbcJobInstanceDao();
        dao.setJdbcTemplate(this.jdbcOperations);
        dao.setJobInstanceIncrementer(this.incrementer);
        dao.setJobKeyGenerator(this.jobKeyGenerator);
        dao.setTablePrefix(this.tablePrefix);
        dao.afterPropertiesSet();
        return dao;
    }

    @Override
    protected JobExecutionDao createJobExecutionDao() throws Exception {
        JdbcJobExecutionDao dao = new JdbcJobExecutionDao();
        dao.setJdbcTemplate(this.jdbcOperations);
        dao.setJobExecutionIncrementer(this.incrementer);
        dao.setTablePrefix(this.tablePrefix);
        dao.setConversionService(this.conversionService);
        dao.afterPropertiesSet();
        return dao;
    }

    @Override
    protected StepExecutionDao createStepExecutionDao() throws Exception {
        JdbcStepExecutionDao dao = new JdbcStepExecutionDao();
        dao.setJdbcTemplate(this.jdbcOperations);
        dao.setStepExecutionIncrementer(this.incrementer);
        dao.setTablePrefix(this.tablePrefix);
        dao.afterPropertiesSet();
        return dao;
    }
}

