/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.observability;

import io.micrometer.common.KeyValues;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.observability.BatchStepContext;
import org.springframework.batch.core.observability.BatchStepObservation;
import org.springframework.batch.core.observability.BatchStepObservationConvention;

public class DefaultBatchStepObservationConvention
implements BatchStepObservationConvention {
    @Override
    public KeyValues getLowCardinalityKeyValues(BatchStepContext context) {
        StepExecution execution = context.getStepExecution();
        return KeyValues.of(BatchStepObservation.StepLowCardinalityTags.STEP_NAME.withValue(execution.getStepName()), BatchStepObservation.StepLowCardinalityTags.JOB_NAME.withValue(execution.getJobExecution().getJobInstance().getJobName()), BatchStepObservation.StepLowCardinalityTags.STEP_STATUS.withValue(execution.getExitStatus().getExitCode()));
    }

    @Override
    public KeyValues getHighCardinalityKeyValues(BatchStepContext context) {
        StepExecution execution = context.getStepExecution();
        return KeyValues.of(BatchStepObservation.StepHighCardinalityTags.STEP_EXECUTION_ID.withValue(String.valueOf(execution.getId())));
    }
}

