/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.partition.support;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.partition.StepExecutionSplitter;
import org.springframework.batch.core.partition.support.PartitionNameProvider;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class SimpleStepExecutionSplitter
implements StepExecutionSplitter,
InitializingBean {
    private static final String STEP_NAME_SEPARATOR = ":";
    private String stepName;
    private Partitioner partitioner;
    private boolean allowStartIfComplete = false;
    private JobRepository jobRepository;

    public SimpleStepExecutionSplitter() {
    }

    public SimpleStepExecutionSplitter(JobRepository jobRepository, boolean allowStartIfComplete, String stepName, Partitioner partitioner) {
        this.jobRepository = jobRepository;
        this.allowStartIfComplete = allowStartIfComplete;
        this.partitioner = partitioner;
        this.stepName = stepName;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.jobRepository != null, "A JobRepository is required");
        Assert.state(this.stepName != null, "A step name is required");
        Assert.state(this.partitioner != null, "A Partitioner is required");
    }

    public void setAllowStartIfComplete(boolean allowStartIfComplete) {
        this.allowStartIfComplete = allowStartIfComplete;
    }

    public void setJobRepository(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    public void setPartitioner(Partitioner partitioner) {
        this.partitioner = partitioner;
    }

    public void setStepName(String stepName) {
        this.stepName = stepName;
    }

    @Override
    public String getStepName() {
        return this.stepName;
    }

    @Override
    public Set<StepExecution> split(StepExecution stepExecution, int gridSize) throws JobExecutionException {
        JobExecution jobExecution = stepExecution.getJobExecution();
        Map<String, ExecutionContext> contexts = this.getContexts(stepExecution, gridSize);
        HashSet<StepExecution> set = new HashSet<StepExecution>(contexts.size());
        for (Map.Entry<String, ExecutionContext> context : contexts.entrySet()) {
            String stepName = this.stepName + STEP_NAME_SEPARATOR + context.getKey();
            StepExecution currentStepExecution = jobExecution.createStepExecution(stepName);
            boolean startable = this.isStartable(currentStepExecution, context.getValue());
            if (!startable) continue;
            set.add(currentStepExecution);
        }
        this.jobRepository.addAll(set);
        HashSet<StepExecution> executions = new HashSet<StepExecution>(set.size());
        executions.addAll(set);
        return executions;
    }

    private Map<String, ExecutionContext> getContexts(StepExecution stepExecution, int gridSize) {
        HashMap<String, ExecutionContext> result;
        ExecutionContext context = stepExecution.getExecutionContext();
        String key = SimpleStepExecutionSplitter.class.getSimpleName() + ".GRID_SIZE";
        int splitSize = (int)context.getLong(key, gridSize);
        context.putLong(key, splitSize);
        if (context.isDirty()) {
            this.jobRepository.updateExecutionContext(stepExecution);
            result = this.partitioner.partition(splitSize);
        } else if (this.partitioner instanceof PartitionNameProvider) {
            result = new HashMap();
            Collection<String> names = ((PartitionNameProvider)((Object)this.partitioner)).getPartitionNames(splitSize);
            for (String name : names) {
                result.put(name, new ExecutionContext());
            }
        } else {
            result = this.partitioner.partition(splitSize);
        }
        return result;
    }

    protected boolean isStartable(StepExecution stepExecution, ExecutionContext context) throws JobExecutionException {
        boolean isRestart;
        String stepName;
        JobInstance jobInstance = stepExecution.getJobExecution().getJobInstance();
        StepExecution lastStepExecution = this.jobRepository.getLastStepExecution(jobInstance, stepName = stepExecution.getStepName());
        boolean bl = isRestart = lastStepExecution != null && lastStepExecution.getStatus() != BatchStatus.COMPLETED;
        if (isRestart) {
            stepExecution.setExecutionContext(lastStepExecution.getExecutionContext());
        } else {
            stepExecution.setExecutionContext(context);
        }
        return this.shouldStart(this.allowStartIfComplete, stepExecution, lastStepExecution) || isRestart;
    }

    private boolean shouldStart(boolean allowStartIfComplete, StepExecution stepExecution, StepExecution lastStepExecution) throws JobExecutionException {
        if (lastStepExecution == null) {
            return true;
        }
        BatchStatus stepStatus = lastStepExecution.getStatus();
        if (stepStatus == BatchStatus.UNKNOWN) {
            throw new JobExecutionException("Cannot restart step from UNKNOWN status.  The last execution ended with a failure that could not be rolled back, so it may be dangerous to proceed.  Manual intervention is probably necessary.");
        }
        if (stepStatus == BatchStatus.COMPLETED) {
            if (!allowStartIfComplete) {
                return this.isSameJobExecution(stepExecution, lastStepExecution);
            }
            return true;
        }
        if (stepStatus == BatchStatus.STOPPED || stepStatus == BatchStatus.FAILED) {
            return true;
        }
        if (stepStatus == BatchStatus.STARTED || stepStatus == BatchStatus.STARTING || stepStatus == BatchStatus.STOPPING) {
            throw new JobExecutionException("Cannot restart step from " + stepStatus + " status.  The old execution may still be executing, so you may need to verify manually that this is the case.");
        }
        throw new JobExecutionException("Cannot restart step from " + stepStatus + " status.  We believe the old execution was abandoned and therefore has been marked as un-restartable.");
    }

    private boolean isSameJobExecution(StepExecution stepExecution, StepExecution lastStepExecution) {
        if (stepExecution.getJobExecutionId() == null) {
            return lastStepExecution.getJobExecutionId() == null;
        }
        return stepExecution.getJobExecutionId().equals(lastStepExecution.getJobExecutionId());
    }
}

