/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.bson.BsonReader;
import org.bson.Document;
import org.bson.codecs.DecoderContext;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.util.json.ParameterBindingDocumentCodec;
import org.springframework.data.mongodb.util.json.ParameterBindingJsonReader;
import org.springframework.data.util.CloseableIterator;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class MongoCursorItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements InitializingBean {
    private MongoOperations template;
    private Class<? extends T> targetType;
    private String collection;
    private Query query;
    private String queryString;
    private List<Object> parameterValues = new ArrayList<Object>();
    private String fields;
    private Sort sort;
    private String hint;
    private int batchSize;
    private int limit;
    private Duration maxTime;
    private CloseableIterator<? extends T> cursor;

    public MongoCursorItemReader() {
        this.setName(ClassUtils.getShortName(MongoCursorItemReader.class));
    }

    public void setTemplate(MongoOperations template) {
        this.template = template;
    }

    public void setTargetType(Class<? extends T> targetType) {
        this.targetType = targetType;
    }

    public void setCollection(String collection) {
        this.collection = collection;
    }

    public void setQuery(Query query2) {
        this.query = query2;
    }

    public void setQuery(String queryString) {
        this.queryString = queryString;
    }

    public void setParameterValues(List<Object> parameterValues) {
        Assert.notNull(parameterValues, "Parameter values must not be null");
        this.parameterValues = parameterValues;
    }

    public void setFields(String fields) {
        this.fields = fields;
    }

    public void setSort(Map<String, Sort.Direction> sorts) {
        Assert.notNull(sorts, "Sorts must not be null");
        this.sort = this.convertToSort(sorts);
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setMaxTime(Duration maxTime) {
        Assert.notNull((Object)maxTime, "maxTime must not be null.");
        this.maxTime = maxTime;
    }

    @Override
    public void afterPropertiesSet() {
        Assert.state(this.template != null, "An implementation of MongoOperations is required.");
        Assert.state(this.targetType != null, "A targetType to convert the input into is required.");
        Assert.state(this.queryString != null || this.query != null, "A query is required.");
        if (this.queryString != null) {
            Assert.state(this.sort != null, "A sort is required.");
        }
    }

    @Override
    protected void doOpen() throws Exception {
        Query mongoQuery = this.queryString != null ? this.createQuery() : this.query;
        Stream stream = StringUtils.hasText(this.collection) ? this.template.stream(mongoQuery, this.targetType, this.collection) : this.template.stream(mongoQuery, this.targetType);
        this.cursor = this.streamToIterator(stream);
    }

    @Override
    protected T doRead() throws Exception {
        return (T)(this.cursor.hasNext() ? this.cursor.next() : null);
    }

    @Override
    protected void doClose() throws Exception {
        this.cursor.close();
    }

    private Sort convertToSort(Map<String, Sort.Direction> sorts) {
        ArrayList<Sort.Order> sortValues = new ArrayList<Sort.Order>(sorts.size());
        for (Map.Entry<String, Sort.Direction> curSort : sorts.entrySet()) {
            sortValues.add(new Sort.Order(curSort.getValue(), curSort.getKey()));
        }
        return Sort.by(sortValues);
    }

    private Query createQuery() {
        String populatedQuery = this.replacePlaceholders(this.queryString, this.parameterValues);
        BasicQuery mongoQuery = StringUtils.hasText(this.fields) ? new BasicQuery(populatedQuery, this.fields) : new BasicQuery(populatedQuery);
        if (this.sort != null) {
            mongoQuery.with(this.sort);
        }
        if (StringUtils.hasText(this.hint)) {
            mongoQuery.withHint(this.hint);
        }
        mongoQuery.cursorBatchSize(this.batchSize);
        mongoQuery.limit(this.limit);
        if (this.maxTime != null) {
            mongoQuery.maxTime(this.maxTime);
        } else {
            mongoQuery.noCursorTimeout();
        }
        return mongoQuery;
    }

    private String replacePlaceholders(String input, List<Object> values) {
        ParameterBindingJsonReader reader = new ParameterBindingJsonReader(input, values.toArray());
        DecoderContext decoderContext = DecoderContext.builder().build();
        Document document = new ParameterBindingDocumentCodec().decode((BsonReader)reader, decoderContext);
        return document.toJson();
    }

    private CloseableIterator<? extends T> streamToIterator(final Stream<? extends T> stream) {
        return new CloseableIterator<T>(){
            private final Iterator<? extends T> delegate;
            {
                this.delegate = stream.iterator();
            }

            public boolean hasNext() {
                return this.delegate.hasNext();
            }

            public T next() {
                return this.delegate.next();
            }

            public void close() {
                stream.close();
            }
        };
    }
}

