/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.database;

import java.io.PrintWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.datasource.ConnectionProxy;
import org.springframework.jdbc.datasource.SmartDataSource;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.MethodInvoker;

public class ExtendedConnectionDataSourceProxy
implements SmartDataSource,
InitializingBean {
    private DataSource dataSource;
    private Connection closeSuppressedConnection = null;
    private boolean borrowedConnection = false;
    private final Lock connectionMonitor = new ReentrantLock();

    public ExtendedConnectionDataSourceProxy() {
    }

    public ExtendedConnectionDataSourceProxy(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public boolean shouldClose(Connection connection) {
        boolean shouldClose;
        boolean bl = shouldClose = !this.isCloseSuppressionActive(connection);
        if (this.borrowedConnection && this.closeSuppressedConnection.equals(connection)) {
            this.borrowedConnection = false;
        }
        return shouldClose;
    }

    public boolean isCloseSuppressionActive(Connection connection) {
        return connection != null && connection.equals(this.closeSuppressedConnection);
    }

    public void startCloseSuppression(Connection connection) {
        this.connectionMonitor.lock();
        try {
            this.closeSuppressedConnection = connection;
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                this.borrowedConnection = true;
            }
        }
        finally {
            this.connectionMonitor.unlock();
        }
    }

    public void stopCloseSuppression(Connection connection) {
        this.connectionMonitor.lock();
        try {
            this.closeSuppressedConnection = null;
            this.borrowedConnection = false;
        }
        finally {
            this.connectionMonitor.unlock();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.connectionMonitor.lock();
        try {
            Connection connection = this.initConnection(null, null);
            return connection;
        }
        finally {
            this.connectionMonitor.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.connectionMonitor.lock();
        try {
            Connection connection = this.initConnection(username, password);
            return connection;
        }
        finally {
            this.connectionMonitor.unlock();
        }
    }

    private boolean completeCloseCall(Connection connection) {
        if (this.borrowedConnection && this.closeSuppressedConnection.equals(connection)) {
            this.borrowedConnection = false;
        }
        return this.isCloseSuppressionActive(connection);
    }

    private Connection initConnection(String username, String password) throws SQLException {
        if (this.closeSuppressedConnection != null && !this.borrowedConnection) {
            this.borrowedConnection = true;
            return this.closeSuppressedConnection;
        }
        Connection target = username != null ? this.dataSource.getConnection(username, password) : this.dataSource.getConnection();
        return this.getCloseSuppressingConnectionProxy(target);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    protected Connection getCloseSuppressingConnectionProxy(Connection target) {
        return (Connection)Proxy.newProxyInstance(ConnectionProxy.class.getClassLoader(), new Class[]{ConnectionProxy.class}, (InvocationHandler)new CloseSuppressingInvocationHandler(target, this));
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(SmartDataSource.class) || iface.isAssignableFrom(this.dataSource.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(SmartDataSource.class)) {
            ExtendedConnectionDataSourceProxy casted = this;
            return (T)casted;
        }
        if (iface.isAssignableFrom(this.dataSource.getClass())) {
            DataSource casted = this.dataSource;
            return (T)casted;
        }
        throw new SQLException("Unsupported class " + iface.getSimpleName());
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.state(this.dataSource != null, "DataSource is required");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        MethodInvoker invoker = new MethodInvoker();
        invoker.setTargetObject(this.dataSource);
        invoker.setTargetMethod("getParentLogger");
        try {
            invoker.prepare();
            return (Logger)invoker.invoke();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException nsme) {
            throw new SQLFeatureNotSupportedException(nsme);
        }
    }

    private static class CloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Connection target;
        private final ExtendedConnectionDataSourceProxy dataSource;

        public CloseSuppressingInvocationHandler(Connection target, ExtendedConnectionDataSourceProxy dataSource) {
            this.dataSource = dataSource;
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "equals": {
                    return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
                }
                case "hashCode": {
                    return System.identityHashCode(proxy);
                }
                case "close": {
                    if (this.dataSource.completeCloseCall((Connection)proxy)) {
                        return null;
                    }
                    this.target.close();
                    return null;
                }
                case "getTargetConnection": {
                    return this.target;
                }
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

