/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.jms;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.Chunk;
import org.springframework.batch.item.ItemWriter;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.util.Assert;

public class JmsItemWriter<T>
implements ItemWriter<T> {
    protected Log logger = LogFactory.getLog(this.getClass());
    private JmsOperations jmsTemplate;

    public void setJmsTemplate(JmsOperations jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
        if (jmsTemplate instanceof JmsTemplate) {
            JmsTemplate template = (JmsTemplate)jmsTemplate;
            Assert.isTrue(template.getDefaultDestination() != null || template.getDefaultDestinationName() != null, "JmsTemplate must have a defaultDestination or defaultDestinationName!");
        }
    }

    @Override
    public void write(Chunk<? extends T> items) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Writing to JMS with " + items.size() + " items.");
        }
        for (Object item : items) {
            this.jmsTemplate.convertAndSend(item);
        }
    }
}

