/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.support;

import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemCountAware;
import org.springframework.batch.item.ItemStreamException;
import org.springframework.batch.item.support.AbstractItemStreamItemReader;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractItemCountingItemStreamItemReader<T>
extends AbstractItemStreamItemReader<T> {
    private static final String READ_COUNT = "read.count";
    private static final String READ_COUNT_MAX = "read.count.max";
    private int currentItemCount = 0;
    private int maxItemCount = Integer.MAX_VALUE;
    private boolean saveState = true;

    @Nullable
    protected abstract T doRead() throws Exception;

    protected abstract void doOpen() throws Exception;

    protected abstract void doClose() throws Exception;

    protected void jumpToItem(int itemIndex) throws Exception {
        for (int i = 0; i < itemIndex; ++i) {
            this.read();
        }
    }

    @Override
    @Nullable
    public T read() throws Exception {
        if (this.currentItemCount >= this.maxItemCount) {
            return null;
        }
        ++this.currentItemCount;
        T item = this.doRead();
        if (item instanceof ItemCountAware) {
            ((ItemCountAware)item).setItemCount(this.currentItemCount);
        }
        return item;
    }

    public int getCurrentItemCount() {
        return this.currentItemCount;
    }

    public void setCurrentItemCount(int count) {
        this.currentItemCount = count;
    }

    public void setMaxItemCount(int count) {
        Assert.isTrue(count > 0, "count must be greater than zero");
        this.maxItemCount = count;
    }

    @Override
    public void close() throws ItemStreamException {
        super.close();
        this.currentItemCount = 0;
        try {
            this.doClose();
        }
        catch (Exception e) {
            throw new ItemStreamException("Error while closing item reader", e);
        }
    }

    @Override
    public void open(ExecutionContext executionContext) throws ItemStreamException {
        super.open(executionContext);
        try {
            this.doOpen();
        }
        catch (Exception e) {
            throw new ItemStreamException("Failed to initialize the reader", e);
        }
        if (!this.isSaveState()) {
            return;
        }
        if (executionContext.containsKey(this.getExecutionContextKey(READ_COUNT_MAX))) {
            this.maxItemCount = executionContext.getInt(this.getExecutionContextKey(READ_COUNT_MAX));
        }
        int itemCount = 0;
        if (executionContext.containsKey(this.getExecutionContextKey(READ_COUNT))) {
            itemCount = executionContext.getInt(this.getExecutionContextKey(READ_COUNT));
        } else if (this.currentItemCount > 0) {
            itemCount = this.currentItemCount;
        }
        if (itemCount > 0 && itemCount < this.maxItemCount) {
            try {
                this.jumpToItem(itemCount);
            }
            catch (Exception e) {
                throw new ItemStreamException("Could not move to stored position on restart", e);
            }
        }
        this.currentItemCount = itemCount;
    }

    @Override
    public void update(ExecutionContext executionContext) throws ItemStreamException {
        super.update(executionContext);
        if (this.saveState) {
            Assert.notNull((Object)executionContext, "ExecutionContext must not be null");
            executionContext.putInt(this.getExecutionContextKey(READ_COUNT), this.currentItemCount);
            if (this.maxItemCount < Integer.MAX_VALUE) {
                executionContext.putInt(this.getExecutionContextKey(READ_COUNT_MAX), this.maxItemCount);
            }
        }
    }

    public void setSaveState(boolean saveState) {
        this.saveState = saveState;
    }

    public boolean isSaveState() {
        return this.saveState;
    }
}

