/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.support;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class PropertiesConverter {
    private static final String LINE_SEPARATOR = "\n";

    private PropertiesConverter() {
    }

    public static Properties stringToProperties(@NonNull String stringToParse) {
        String[] keyValuePairs;
        Assert.notNull((Object)stringToParse, "stringToParse must not be null");
        if (!StringUtils.hasText(stringToParse)) {
            return new Properties();
        }
        Properties properties = new Properties();
        for (String string : keyValuePairs = stringToParse.split(LINE_SEPARATOR)) {
            if (!string.contains("=")) {
                throw new IllegalArgumentException(string + "is not a valid key=value pair");
            }
            String[] keyValuePair = string.split("=");
            properties.setProperty(keyValuePair[0], keyValuePair[1]);
        }
        return properties;
    }

    public static String propertiesToString(@NonNull Properties propertiesToParse) {
        Assert.notNull((Object)propertiesToParse, "propertiesToParse must not be null");
        if (propertiesToParse.isEmpty()) {
            return "";
        }
        ArrayList<CallSite> keyValuePairs = new ArrayList<CallSite>();
        for (Map.Entry<Object, Object> entry : propertiesToParse.entrySet()) {
            keyValuePairs.add((CallSite)((Object)(entry.getKey() + "=" + entry.getValue())));
        }
        return String.join((CharSequence)LINE_SEPARATOR, keyValuePairs);
    }
}

