/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.support.SQLExceptionTranslator;
import org.springframework.lang.Nullable;

public final class CustomSQLExceptionTranslatorRegistry {
    private static final Log logger = LogFactory.getLog(CustomSQLExceptionTranslatorRegistry.class);
    private static final CustomSQLExceptionTranslatorRegistry instance = new CustomSQLExceptionTranslatorRegistry();
    private final Map<String, SQLExceptionTranslator> translatorMap = new HashMap<String, SQLExceptionTranslator>();

    public static CustomSQLExceptionTranslatorRegistry getInstance() {
        return instance;
    }

    private CustomSQLExceptionTranslatorRegistry() {
    }

    public void registerTranslator(String dbName, SQLExceptionTranslator translator) {
        SQLExceptionTranslator replaced = this.translatorMap.put(dbName, translator);
        if (logger.isDebugEnabled()) {
            if (replaced != null) {
                logger.debug("Replacing custom translator [" + String.valueOf(replaced) + "] for database '" + dbName + "' with [" + String.valueOf(translator) + "]");
            } else {
                logger.debug("Adding custom translator of type [" + translator.getClass().getName() + "] for database '" + dbName + "'");
            }
        }
    }

    @Nullable
    public SQLExceptionTranslator findTranslatorForDatabase(String dbName) {
        return this.translatorMap.get(dbName);
    }
}

