/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.patterns.NamePattern;
import org.aspectj.weaver.reflect.ReflectionWorld;
import org.aspectj.weaver.reflect.ShadowMatchImpl;
import org.aspectj.weaver.tools.ContextBasedMatcher;
import org.aspectj.weaver.tools.JoinPointMatch;
import org.aspectj.weaver.tools.MatchingContext;
import org.aspectj.weaver.tools.PointcutDesignatorHandler;
import org.aspectj.weaver.tools.PointcutExpression;
import org.aspectj.weaver.tools.PointcutParameter;
import org.aspectj.weaver.tools.PointcutParser;
import org.aspectj.weaver.tools.PointcutPrimitive;
import org.aspectj.weaver.tools.ShadowMatch;
import org.aspectj.weaver.tools.UnsupportedPointcutPrimitiveException;
import org.springframework.aop.ClassFilter;
import org.springframework.aop.IntroductionAwareMethodMatcher;
import org.springframework.aop.MethodMatcher;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.aop.aspectj.RuntimeTestWalker;
import org.springframework.aop.aspectj.ShadowMatchUtils;
import org.springframework.aop.framework.autoproxy.ProxyCreationContext;
import org.springframework.aop.interceptor.ExposeInvocationInterceptor;
import org.springframework.aop.support.AbstractExpressionPointcut;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AspectJExpressionPointcut
extends AbstractExpressionPointcut
implements ClassFilter,
IntroductionAwareMethodMatcher,
BeanFactoryAware {
    private static final String AJC_MAGIC = "ajc$";
    private static final Set<PointcutPrimitive> SUPPORTED_PRIMITIVES = Set.of(PointcutPrimitive.EXECUTION, PointcutPrimitive.ARGS, PointcutPrimitive.REFERENCE, PointcutPrimitive.THIS, PointcutPrimitive.TARGET, PointcutPrimitive.WITHIN, PointcutPrimitive.AT_ANNOTATION, PointcutPrimitive.AT_WITHIN, PointcutPrimitive.AT_ARGS, PointcutPrimitive.AT_TARGET);
    private static final Log logger = LogFactory.getLog(AspectJExpressionPointcut.class);
    @Nullable
    private Class<?> pointcutDeclarationScope;
    private boolean aspectCompiledByAjc;
    private String[] pointcutParameterNames = new String[0];
    private Class<?>[] pointcutParameterTypes = new Class[0];
    @Nullable
    private BeanFactory beanFactory;
    @Nullable
    private volatile transient ClassLoader pointcutClassLoader;
    @Nullable
    private volatile transient PointcutExpression pointcutExpression;
    private volatile transient boolean pointcutParsingFailed;

    public AspectJExpressionPointcut() {
    }

    public AspectJExpressionPointcut(Class<?> declarationScope, String[] paramNames, Class<?>[] paramTypes) {
        this.setPointcutDeclarationScope(declarationScope);
        if (paramNames.length != paramTypes.length) {
            throw new IllegalStateException("Number of pointcut parameter names must match number of pointcut parameter types");
        }
        this.pointcutParameterNames = paramNames;
        this.pointcutParameterTypes = paramTypes;
    }

    public void setPointcutDeclarationScope(Class<?> pointcutDeclarationScope) {
        this.pointcutDeclarationScope = pointcutDeclarationScope;
        this.aspectCompiledByAjc = AspectJExpressionPointcut.compiledByAjc(pointcutDeclarationScope);
    }

    public void setParameterNames(String ... names) {
        this.pointcutParameterNames = names;
    }

    public void setParameterTypes(Class<?> ... types) {
        this.pointcutParameterTypes = types;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public ClassFilter getClassFilter() {
        this.checkExpression();
        return this;
    }

    @Override
    public MethodMatcher getMethodMatcher() {
        this.checkExpression();
        return this;
    }

    private void checkExpression() {
        if (this.getExpression() == null) {
            throw new IllegalStateException("Must set property 'expression' before attempting to match");
        }
    }

    private PointcutExpression obtainPointcutExpression() {
        PointcutExpression pointcutExpression = this.pointcutExpression;
        if (pointcutExpression == null) {
            ClassLoader pointcutClassLoader = this.determinePointcutClassLoader();
            pointcutExpression = this.buildPointcutExpression(pointcutClassLoader);
            this.pointcutClassLoader = pointcutClassLoader;
            this.pointcutExpression = pointcutExpression;
        }
        return pointcutExpression;
    }

    @Nullable
    private ClassLoader determinePointcutClassLoader() {
        BeanFactory beanFactory = this.beanFactory;
        if (beanFactory instanceof ConfigurableBeanFactory) {
            ConfigurableBeanFactory cbf = (ConfigurableBeanFactory)beanFactory;
            return cbf.getBeanClassLoader();
        }
        if (this.pointcutDeclarationScope != null) {
            return this.pointcutDeclarationScope.getClassLoader();
        }
        return ClassUtils.getDefaultClassLoader();
    }

    private PointcutExpression buildPointcutExpression(@Nullable ClassLoader classLoader) {
        PointcutParser parser = this.initializePointcutParser(classLoader);
        PointcutParameter[] pointcutParameters = new PointcutParameter[this.pointcutParameterNames.length];
        for (int i = 0; i < pointcutParameters.length; ++i) {
            pointcutParameters[i] = parser.createPointcutParameter(this.pointcutParameterNames[i], this.pointcutParameterTypes[i]);
        }
        return parser.parsePointcutExpression(this.replaceBooleanOperators(this.resolveExpression()), this.pointcutDeclarationScope, pointcutParameters);
    }

    private String resolveExpression() {
        String expression = this.getExpression();
        Assert.state(expression != null, "No expression set");
        return expression;
    }

    private PointcutParser initializePointcutParser(@Nullable ClassLoader classLoader) {
        PointcutParser parser = PointcutParser.getPointcutParserSupportingSpecifiedPrimitivesAndUsingSpecifiedClassLoaderForResolution(SUPPORTED_PRIMITIVES, (ClassLoader)classLoader);
        parser.registerPointcutDesignatorHandler((PointcutDesignatorHandler)new BeanPointcutDesignatorHandler());
        return parser;
    }

    private String replaceBooleanOperators(String pcExpr) {
        String result = StringUtils.replace(pcExpr, " and ", " && ");
        result = StringUtils.replace(result, " or ", " || ");
        result = StringUtils.replace(result, " not ", " ! ");
        return result;
    }

    public PointcutExpression getPointcutExpression() {
        return this.obtainPointcutExpression();
    }

    @Override
    public boolean matches(Class<?> targetClass) {
        if (this.pointcutParsingFailed) {
            return false;
        }
        if (this.aspectCompiledByAjc && AspectJExpressionPointcut.compiledByAjc(targetClass)) {
            return false;
        }
        try {
            try {
                return this.obtainPointcutExpression().couldMatchJoinPointsInType(targetClass);
            }
            catch (ReflectionWorld.ReflectionWorldException ex) {
                logger.debug("PointcutExpression matching rejected target class - trying fallback expression", ex);
                PointcutExpression fallbackExpression = this.getFallbackPointcutExpression(targetClass);
                if (fallbackExpression != null) {
                    return fallbackExpression.couldMatchJoinPointsInType(targetClass);
                }
            }
        }
        catch (IllegalArgumentException | IllegalStateException | UnsupportedPointcutPrimitiveException ex) {
            this.pointcutParsingFailed = true;
            if (logger.isDebugEnabled()) {
                logger.debug("Pointcut parser rejected expression [" + this.getExpression() + "]: " + String.valueOf(ex));
            }
        }
        catch (Throwable ex) {
            logger.debug("PointcutExpression matching rejected target class", ex);
        }
        return false;
    }

    @Override
    public boolean matches(Method method, Class<?> targetClass, boolean hasIntroductions) {
        ShadowMatch shadowMatch = this.getTargetShadowMatch(method, targetClass);
        if (shadowMatch.alwaysMatches()) {
            return true;
        }
        if (shadowMatch.neverMatches()) {
            return false;
        }
        if (hasIntroductions) {
            return true;
        }
        RuntimeTestWalker walker = this.getRuntimeTestWalker(shadowMatch);
        return !walker.testsSubtypeSensitiveVars() || walker.testTargetInstanceOfResidue(targetClass);
    }

    @Override
    public boolean matches(Method method, Class<?> targetClass) {
        return this.matches(method, targetClass, false);
    }

    @Override
    public boolean isRuntime() {
        return this.obtainPointcutExpression().mayNeedDynamicTest();
    }

    @Override
    public boolean matches(Method method, Class<?> targetClass, Object ... args) {
        Object thisObject;
        Object targetObject;
        ProxyMethodInvocation pmi;
        ShadowMatch shadowMatch;
        block10: {
            shadowMatch = this.getTargetShadowMatch(method, targetClass);
            pmi = null;
            targetObject = null;
            thisObject = null;
            try {
                MethodInvocation curr = ExposeInvocationInterceptor.currentInvocation();
                if (curr.getMethod() == method) {
                    targetObject = curr.getThis();
                    if (!(curr instanceof ProxyMethodInvocation)) {
                        throw new IllegalStateException("MethodInvocation is not a Spring ProxyMethodInvocation: " + String.valueOf(curr));
                    }
                    ProxyMethodInvocation currPmi = (ProxyMethodInvocation)curr;
                    pmi = currPmi;
                    thisObject = pmi.getProxy();
                }
            }
            catch (IllegalStateException ex) {
                if (!logger.isDebugEnabled()) break block10;
                logger.debug("Could not access current invocation - matching with limited context: " + String.valueOf(ex));
            }
        }
        try {
            JoinPointMatch joinPointMatch = shadowMatch.matchesJoinPoint(thisObject, targetObject, args);
            if (pmi != null && thisObject != null) {
                RuntimeTestWalker originalMethodResidueTest = this.getRuntimeTestWalker(this.getShadowMatch(method, method));
                if (!originalMethodResidueTest.testThisInstanceOfResidue(thisObject.getClass())) {
                    return false;
                }
                if (joinPointMatch.matches()) {
                    this.bindParameters(pmi, joinPointMatch);
                }
            }
            return joinPointMatch.matches();
        }
        catch (Throwable ex) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to evaluate join point for arguments " + Arrays.toString(args) + " - falling back to non-match", ex);
            }
            return false;
        }
    }

    @Nullable
    protected String getCurrentProxiedBeanName() {
        return ProxyCreationContext.getCurrentProxiedBeanName();
    }

    @Nullable
    private PointcutExpression getFallbackPointcutExpression(Class<?> targetClass) {
        try {
            ClassLoader classLoader = targetClass.getClassLoader();
            if (classLoader != null && classLoader != this.pointcutClassLoader) {
                return this.buildPointcutExpression(classLoader);
            }
        }
        catch (Throwable ex) {
            logger.debug("Failed to create fallback PointcutExpression", ex);
        }
        return null;
    }

    private RuntimeTestWalker getRuntimeTestWalker(ShadowMatch shadowMatch) {
        if (shadowMatch instanceof DefensiveShadowMatch) {
            DefensiveShadowMatch defensiveShadowMatch = (DefensiveShadowMatch)shadowMatch;
            return new RuntimeTestWalker(defensiveShadowMatch.primary);
        }
        return new RuntimeTestWalker(shadowMatch);
    }

    private void bindParameters(ProxyMethodInvocation invocation, JoinPointMatch jpm) {
        invocation.setUserAttribute(this.resolveExpression(), jpm);
    }

    private ShadowMatch getTargetShadowMatch(Method method, Class<?> targetClass) {
        Set<Class<?>> ifcs;
        Method targetMethod = AopUtils.getMostSpecificMethod(method, targetClass);
        if (targetMethod.getDeclaringClass().isInterface() && targetMethod.getDeclaringClass() != targetClass && this.obtainPointcutExpression().getPointcutExpression().contains("." + targetMethod.getName() + "(") && (ifcs = ClassUtils.getAllInterfacesForClassAsSet(targetClass)).size() > 1) {
            try {
                Class<?> compositeInterface = ClassUtils.createCompositeInterface(ClassUtils.toClassArray(ifcs), targetClass.getClassLoader());
                targetMethod = ClassUtils.getMostSpecificMethod(targetMethod, compositeInterface);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this.getShadowMatch(targetMethod, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ShadowMatch getShadowMatch(Method targetMethod, Method originalMethod) {
        ShadowMatchKey key = new ShadowMatchKey(this, targetMethod);
        ShadowMatch shadowMatch = ShadowMatchUtils.getShadowMatch(key);
        if (shadowMatch == null) {
            PointcutExpression pointcutExpression;
            PointcutExpression pointcutExpression2 = pointcutExpression = this.obtainPointcutExpression();
            synchronized (pointcutExpression2) {
                Method methodToMatch;
                PointcutExpression fallbackExpression;
                block20: {
                    shadowMatch = ShadowMatchUtils.getShadowMatch(key);
                    if (shadowMatch != null) {
                        return shadowMatch;
                    }
                    fallbackExpression = null;
                    methodToMatch = targetMethod;
                    try {
                        try {
                            shadowMatch = pointcutExpression.matchesMethodExecution(methodToMatch);
                        }
                        catch (ReflectionWorld.ReflectionWorldException ex) {
                            try {
                                fallbackExpression = this.getFallbackPointcutExpression(methodToMatch.getDeclaringClass());
                                if (fallbackExpression != null) {
                                    shadowMatch = fallbackExpression.matchesMethodExecution(methodToMatch);
                                }
                            }
                            catch (ReflectionWorld.ReflectionWorldException ex2) {
                                fallbackExpression = null;
                            }
                        }
                        if (targetMethod == originalMethod || shadowMatch != null && (!Proxy.isProxyClass(targetMethod.getDeclaringClass()) || !shadowMatch.neverMatches() && !this.containsAnnotationPointcut())) break block20;
                        methodToMatch = originalMethod;
                        try {
                            shadowMatch = pointcutExpression.matchesMethodExecution(methodToMatch);
                        }
                        catch (ReflectionWorld.ReflectionWorldException ex) {
                            try {
                                fallbackExpression = this.getFallbackPointcutExpression(methodToMatch.getDeclaringClass());
                                if (fallbackExpression != null) {
                                    shadowMatch = fallbackExpression.matchesMethodExecution(methodToMatch);
                                }
                            }
                            catch (ReflectionWorld.ReflectionWorldException ex2) {
                                fallbackExpression = null;
                            }
                        }
                    }
                    catch (Throwable ex) {
                        logger.debug("PointcutExpression matching rejected target method", ex);
                        fallbackExpression = null;
                    }
                }
                if (shadowMatch == null) {
                    shadowMatch = new ShadowMatchImpl(FuzzyBoolean.NO, null, null, null);
                } else if (shadowMatch.maybeMatches() && fallbackExpression != null) {
                    shadowMatch = new DefensiveShadowMatch(shadowMatch, fallbackExpression.matchesMethodExecution(methodToMatch));
                }
                shadowMatch = ShadowMatchUtils.setShadowMatch(key, shadowMatch);
            }
        }
        return shadowMatch;
    }

    private boolean containsAnnotationPointcut() {
        return this.resolveExpression().contains("@annotation");
    }

    private static boolean compiledByAjc(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!field.getName().startsWith(AJC_MAGIC)) continue;
            return true;
        }
        Class<?> superclass = clazz.getSuperclass();
        return superclass != null && AspectJExpressionPointcut.compiledByAjc(superclass);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof AspectJExpressionPointcut)) return false;
        AspectJExpressionPointcut that = (AspectJExpressionPointcut)other;
        if (!ObjectUtils.nullSafeEquals(this.getExpression(), that.getExpression())) return false;
        if (!ObjectUtils.nullSafeEquals(this.pointcutDeclarationScope, that.pointcutDeclarationScope)) return false;
        if (!ObjectUtils.nullSafeEquals(this.pointcutParameterNames, that.pointcutParameterNames)) return false;
        if (!ObjectUtils.nullSafeEquals(this.pointcutParameterTypes, that.pointcutParameterTypes)) return false;
        return true;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHash(this.getExpression(), this.pointcutDeclarationScope, this.pointcutParameterNames, this.pointcutParameterTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AspectJExpressionPointcut: (");
        for (int i = 0; i < this.pointcutParameterTypes.length; ++i) {
            sb.append(this.pointcutParameterTypes[i].getName());
            sb.append(' ');
            sb.append(this.pointcutParameterNames[i]);
            if (i + 1 >= this.pointcutParameterTypes.length) continue;
            sb.append(", ");
        }
        sb.append(") ");
        if (this.getExpression() != null) {
            sb.append(this.getExpression());
        } else {
            sb.append("<pointcut expression not set>");
        }
        return sb.toString();
    }

    private class BeanPointcutDesignatorHandler
    implements PointcutDesignatorHandler {
        private static final String BEAN_DESIGNATOR_NAME = "bean";

        private BeanPointcutDesignatorHandler() {
        }

        public String getDesignatorName() {
            return BEAN_DESIGNATOR_NAME;
        }

        public ContextBasedMatcher parse(String expression) {
            return new BeanContextMatcher(expression);
        }
    }

    private static class DefensiveShadowMatch
    implements ShadowMatch {
        private final ShadowMatch primary;
        private final ShadowMatch other;

        public DefensiveShadowMatch(ShadowMatch primary, ShadowMatch other) {
            this.primary = primary;
            this.other = other;
        }

        public boolean alwaysMatches() {
            return this.primary.alwaysMatches();
        }

        public boolean maybeMatches() {
            return this.primary.maybeMatches();
        }

        public boolean neverMatches() {
            return this.primary.neverMatches();
        }

        public JoinPointMatch matchesJoinPoint(Object thisObject, Object targetObject, Object[] args) {
            try {
                return this.primary.matchesJoinPoint(thisObject, targetObject, args);
            }
            catch (ReflectionWorld.ReflectionWorldException ex) {
                return this.other.matchesJoinPoint(thisObject, targetObject, args);
            }
        }

        public void setMatchingContext(MatchingContext aMatchContext) {
            this.primary.setMatchingContext(aMatchContext);
            this.other.setMatchingContext(aMatchContext);
        }
    }

    private record ShadowMatchKey(AspectJExpressionPointcut expression, Method method) {
    }

    private class BeanContextMatcher
    implements ContextBasedMatcher {
        private final NamePattern expressionPattern;

        public BeanContextMatcher(String expression) {
            this.expressionPattern = new NamePattern(expression);
        }

        @Deprecated
        public boolean couldMatchJoinPointsInType(Class someClass) {
            return this.contextMatch(someClass) == org.aspectj.weaver.tools.FuzzyBoolean.YES;
        }

        @Deprecated
        public boolean couldMatchJoinPointsInType(Class someClass, MatchingContext context) {
            return this.contextMatch(someClass) == org.aspectj.weaver.tools.FuzzyBoolean.YES;
        }

        public boolean matchesDynamically(MatchingContext context) {
            return true;
        }

        public org.aspectj.weaver.tools.FuzzyBoolean matchesStatically(MatchingContext context) {
            return this.contextMatch(null);
        }

        public boolean mayNeedDynamicTest() {
            return false;
        }

        private org.aspectj.weaver.tools.FuzzyBoolean contextMatch(@Nullable Class<?> targetType) {
            String advisedBeanName = AspectJExpressionPointcut.this.getCurrentProxiedBeanName();
            if (advisedBeanName == null) {
                return org.aspectj.weaver.tools.FuzzyBoolean.MAYBE;
            }
            if (BeanFactoryUtils.isGeneratedBeanName(advisedBeanName)) {
                return org.aspectj.weaver.tools.FuzzyBoolean.NO;
            }
            if (targetType != null) {
                boolean isFactory = FactoryBean.class.isAssignableFrom(targetType);
                return org.aspectj.weaver.tools.FuzzyBoolean.fromBoolean((boolean)this.matchesBean((String)(isFactory ? "&" + advisedBeanName : advisedBeanName)));
            }
            return org.aspectj.weaver.tools.FuzzyBoolean.fromBoolean((this.matchesBean(advisedBeanName) || this.matchesBean("&" + advisedBeanName) ? 1 : 0) != 0);
        }

        private boolean matchesBean(String advisedBeanName) {
            return BeanFactoryAnnotationUtils.isQualifierMatch(arg_0 -> ((NamePattern)this.expressionPattern).matches(arg_0), advisedBeanName, AspectJExpressionPointcut.this.beanFactory);
        }
    }
}

