/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.spel;

import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.StaticService;
import org.apache.camel.language.spel.SpelExpression;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.util.RegistryBeanResolver;
import org.apache.camel.support.TypedLanguageSupport;
import org.apache.camel.util.ObjectHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;

@Language(value="spel")
public class SpelLanguage
extends TypedLanguageSupport
implements StaticService {
    private BeanResolver beanResolver;

    @Override
    public Predicate createPredicate(String expression) {
        return this.createSpelExpression(expression, Boolean.class);
    }

    @Override
    public Expression createExpression(String expression) {
        return this.createSpelExpression(expression, Object.class);
    }

    private SpelExpression createSpelExpression(String expression, Class<?> type) {
        SpelExpression answer = new SpelExpression(this.loadResource(expression), type, this.beanResolver);
        answer.init(this.getCamelContext());
        return answer;
    }

    @Override
    public void init() {
        ObjectHelper.notNull(this.getCamelContext(), "CamelContext", this);
        if (this.getCamelContext() instanceof SpringCamelContext) {
            ApplicationContext applicationContext = ((SpringCamelContext)this.getCamelContext()).getApplicationContext();
            this.beanResolver = new BeanFactoryResolver(applicationContext);
        } else {
            this.beanResolver = new RegistryBeanResolver(this.getCamelContext().getRegistry());
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }
}

