/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.main;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Ordered;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.spi.AutowiredLifecycleStrategy;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Language;
import org.apache.camel.support.LifecycleStrategySupport;

public class MainAutowiredLifecycleStrategy
extends LifecycleStrategySupport
implements AutowiredLifecycleStrategy,
Ordered {
    private final Map<String, Component> autowrieComponents = new HashMap<String, Component>();
    private final Map<String, DataFormat> autowrieDataFormats = new HashMap<String, DataFormat>();
    private final Map<String, Language> autowrieLanguages = new HashMap<String, Language>();
    private final CamelContext camelContext;
    private volatile boolean initializing;

    public MainAutowiredLifecycleStrategy(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Override
    public int getOrder() {
        return 2147482647;
    }

    @Override
    public void onContextInitializing(CamelContext context) throws VetoCamelContextStartException {
        this.autowrieComponents.forEach(this::autowireComponent);
        this.autowrieDataFormats.forEach(this::autowireDataFormat);
        this.autowrieLanguages.forEach(this::autowireLanguage);
        this.autowrieComponents.clear();
        this.autowrieDataFormats.clear();
        this.autowrieLanguages.clear();
        this.initializing = true;
    }

    @Override
    public void onContextStopped(CamelContext context) {
        this.initializing = false;
    }

    @Override
    public void onComponentAdd(String name, Component component) {
        if (this.initializing) {
            this.autowireComponent(name, component);
        } else {
            this.autowrieComponents.put(name, component);
        }
    }

    @Override
    public void onDataFormatCreated(String name, DataFormat dataFormat) {
        if (this.initializing) {
            this.autowireDataFormat(name, dataFormat);
        } else {
            this.autowrieDataFormats.put(name, dataFormat);
        }
    }

    @Override
    public void onLanguageCreated(String name, Language language) {
        if (this.initializing) {
            this.autowireLanguage(name, language);
        } else {
            this.autowrieLanguages.put(name, language);
        }
    }

    protected boolean isEnabled(String name, Component component) {
        return this.camelContext.isAutowiredEnabled() != false && component.isAutowiredEnabled();
    }

    protected boolean isEnabled(String name, Language language) {
        return this.camelContext.isAutowiredEnabled();
    }

    protected boolean isEnabled(String name, DataFormat dataFormat) {
        return this.camelContext.isAutowiredEnabled();
    }

    private void autowireComponent(String name, Component component) {
        if (this.isEnabled(name, component)) {
            this.autowire(name, "component", component);
        }
    }

    private void autowireDataFormat(String name, DataFormat dataFormat) {
        if (this.isEnabled(name, dataFormat)) {
            this.autowire(name, "dataformat", dataFormat);
        }
    }

    private void autowireLanguage(String name, Language language) {
        if (this.isEnabled(name, language)) {
            this.autowire(name, "language", language);
        }
    }

    private void autowire(String name, String kind, Object target) {
        MainAutowiredLifecycleStrategy.doAutoWire(name, kind, target, this.camelContext);
    }
}

